/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.webapp.impl.security.filter.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eximeebpms.bpm.engine.impl.util.ReflectUtil;
import org.eximeebpms.bpm.webapp.impl.security.auth.Authentication;
import org.eximeebpms.bpm.webapp.impl.security.filter.Authorization;
import org.eximeebpms.bpm.webapp.impl.security.filter.PathFilterRule;
import org.eximeebpms.bpm.webapp.impl.security.filter.RequestAuthorizer;
import org.eximeebpms.bpm.webapp.impl.security.filter.RequestFilter;
import org.eximeebpms.bpm.webapp.impl.security.filter.RequestMatcher;
import org.eximeebpms.bpm.webapp.impl.security.filter.SecurityFilterConfig;
import org.eximeebpms.bpm.webapp.impl.security.filter.SecurityFilterRule;

public class FilterRules {
    public static List<SecurityFilterRule> load(InputStream configFileResource, String applicationPath) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        SecurityFilterConfig config = (SecurityFilterConfig)objectMapper.readValue(configFileResource, SecurityFilterConfig.class);
        return FilterRules.createFilterRules(config, applicationPath);
    }

    public static List<SecurityFilterRule> createFilterRules(SecurityFilterConfig config, String applicationPath) {
        SecurityFilterConfig.PathFilterConfig pathFilter = config.getPathFilter();
        PathFilterRule rule = FilterRules.createPathFilterRule(pathFilter, applicationPath);
        return new ArrayList<SecurityFilterRule>(Collections.singletonList(rule));
    }

    protected static PathFilterRule createPathFilterRule(SecurityFilterConfig.PathFilterConfig pathFilter, String applicationPath) {
        PathFilterRule pathFilterRule = new PathFilterRule();
        for (SecurityFilterConfig.PathMatcherConfig pathMatcherConfig : pathFilter.getDeniedPaths()) {
            pathFilterRule.getDeniedPaths().add(FilterRules.transformPathMatcher(pathMatcherConfig, applicationPath));
        }
        for (SecurityFilterConfig.PathMatcherConfig pathMatcherConfig : pathFilter.getAllowedPaths()) {
            pathFilterRule.getAllowedPaths().add(FilterRules.transformPathMatcher(pathMatcherConfig, applicationPath));
        }
        return pathFilterRule;
    }

    protected static RequestMatcher transformPathMatcher(SecurityFilterConfig.PathMatcherConfig pathMatcherConfig, String applicationPath) {
        RequestFilter requestMatcher = new RequestFilter(pathMatcherConfig.getPath(), applicationPath, pathMatcherConfig.getParsedMethods());
        RequestAuthorizer requestAuthorizer = RequestAuthorizer.AUTHORIZE_ANNONYMOUS;
        if (pathMatcherConfig.getAuthorizer() != null) {
            String authorizeCls = pathMatcherConfig.getAuthorizer();
            requestAuthorizer = (RequestAuthorizer)ReflectUtil.instantiate((String)authorizeCls);
        }
        return new RequestMatcher(requestMatcher, requestAuthorizer);
    }

    public static Authorization authorize(String requestMethod, String requestUri, List<SecurityFilterRule> filterRules) {
        for (SecurityFilterRule filterRule : filterRules) {
            Authorization authorization = filterRule.authorize(requestMethod, requestUri);
            if (authorization == null) continue;
            return authorization;
        }
        return Authorization.granted(Authentication.ANONYMOUS);
    }
}

