/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.cockpit.impl.plugin.base.sub.resources;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import org.eximeebpms.bpm.cockpit.db.QueryParameters;
import org.eximeebpms.bpm.cockpit.impl.plugin.base.dto.CalledProcessInstanceDto;
import org.eximeebpms.bpm.cockpit.impl.plugin.base.dto.query.CalledProcessInstanceQueryDto;
import org.eximeebpms.bpm.cockpit.plugin.resource.AbstractPluginResource;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;

public class ProcessInstanceResource
extends AbstractPluginResource {
    protected String id;

    public ProcessInstanceResource(String engineName, String id) {
        super(engineName);
        this.id = id;
    }

    @GET
    @Path(value="/called-process-instances")
    @Produces(value={"application/json"})
    public List<CalledProcessInstanceDto> getCalledProcessInstances(@Context UriInfo uriInfo) {
        CalledProcessInstanceQueryDto queryParameter = new CalledProcessInstanceQueryDto(uriInfo.getQueryParameters());
        return this.queryCalledProcessInstances(queryParameter);
    }

    @POST
    @Path(value="/called-process-instances")
    @Produces(value={"application/json"})
    public List<CalledProcessInstanceDto> queryCalledProcessInstances(CalledProcessInstanceQueryDto queryParameter) {
        queryParameter.setParentProcessInstanceId(this.id);
        this.configureExecutionQuery(queryParameter);
        queryParameter.disableMaxResultsLimit();
        return this.getQueryService().executeQuery("selectCalledProcessInstances", (org.eximeebpms.bpm.webapp.db.QueryParameters)queryParameter);
    }

    protected void configureExecutionQuery(CalledProcessInstanceQueryDto query) {
        this.configureAuthorizationCheck((QueryParameters)query);
        this.configureTenantCheck((QueryParameters)query);
        this.addPermissionCheck((QueryParameters)query, (Resource)Resources.PROCESS_INSTANCE, "EXEC1.PROC_INST_ID_", (Permission)Permissions.READ);
        this.addPermissionCheck((QueryParameters)query, (Resource)Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", (Permission)Permissions.READ_INSTANCE);
    }
}

