/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.cockpit.impl.plugin.resources;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import org.eximeebpms.bpm.cockpit.db.QueryParameters;
import org.eximeebpms.bpm.cockpit.impl.plugin.base.dto.ProcessDefinitionStatisticsDto;
import org.eximeebpms.bpm.cockpit.impl.plugin.base.dto.query.ProcessDefinitionStatisticsQueryDto;
import org.eximeebpms.bpm.cockpit.impl.plugin.base.sub.resources.ProcessDefinitionResource;
import org.eximeebpms.bpm.cockpit.plugin.resource.AbstractPluginResource;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.impl.db.ListQueryParameterObject;
import org.eximeebpms.bpm.engine.rest.dto.CountResultDto;

public class ProcessDefinitionRestService
extends AbstractPluginResource {
    public static final String PATH = "/process-definition";

    public ProcessDefinitionRestService(String engineName) {
        super(engineName);
    }

    @Path(value="/{id}")
    public ProcessDefinitionResource getProcessDefinition(@PathParam(value="id") String id) {
        return new ProcessDefinitionResource(this.getProcessEngine().getName(), id);
    }

    @GET
    @Path(value="/statistics-count")
    @Produces(value={"application/json"})
    public CountResultDto getStatisticsCount(@Context UriInfo uriInfo) {
        ProcessDefinitionStatisticsQueryDto queryDto = new ProcessDefinitionStatisticsQueryDto(uriInfo.getQueryParameters());
        this.configureExecutionQuery((QueryParameters)queryDto);
        long count = this.getQueryService().executeQueryRowCount("selectPDStatisticsCount", (ListQueryParameterObject)queryDto);
        return new CountResultDto(count);
    }

    @GET
    @Path(value="/statistics")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<ProcessDefinitionStatisticsDto> queryStatistics(@Context UriInfo uriInfo, @QueryParam(value="firstResult") Integer firstResult, @QueryParam(value="maxResults") Integer maxResults) {
        ProcessDefinitionStatisticsQueryDto queryDto = new ProcessDefinitionStatisticsQueryDto(uriInfo.getQueryParameters());
        this.configureExecutionQuery((QueryParameters)queryDto);
        queryDto.setFirstResult(firstResult != null && firstResult >= 0 ? firstResult : 0);
        queryDto.setMaxResults(maxResults != null && maxResults > 0 ? maxResults : Integer.MAX_VALUE);
        return this.getQueryService().executeQuery("selectPDStatistics", (org.eximeebpms.bpm.webapp.db.QueryParameters)queryDto);
    }

    protected void configureExecutionQuery(QueryParameters query) {
        this.configureAuthorizationCheck(query);
        this.configureTenantCheck(query);
        this.addPermissionCheck(query, (Resource)Resources.PROCESS_DEFINITION, "RES.KEY_", (Permission)Permissions.READ);
    }
}

