/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.cockpit.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.cockpit.CockpitRuntimeDelegate;
import org.eximeebpms.bpm.cockpit.db.CommandExecutor;
import org.eximeebpms.bpm.cockpit.db.QueryService;
import org.eximeebpms.bpm.cockpit.impl.db.CommandExecutorImpl;
import org.eximeebpms.bpm.cockpit.impl.db.QueryServiceImpl;
import org.eximeebpms.bpm.cockpit.impl.plugin.DefaultPluginRegistry;
import org.eximeebpms.bpm.cockpit.plugin.PluginRegistry;
import org.eximeebpms.bpm.cockpit.plugin.spi.CockpitPlugin;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.impl.ProcessEngineImpl;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.webapp.impl.AbstractAppRuntimeDelegate;

public class DefaultCockpitRuntimeDelegate
extends AbstractAppRuntimeDelegate<CockpitPlugin>
implements CockpitRuntimeDelegate {
    private Map<String, CommandExecutor> commandExecutors = new HashMap();

    public DefaultCockpitRuntimeDelegate() {
        super(CockpitPlugin.class);
    }

    public QueryService getQueryService(String processEngineName) {
        CommandExecutor commandExecutor = this.getCommandExecutor(processEngineName);
        return new QueryServiceImpl(commandExecutor);
    }

    public CommandExecutor getCommandExecutor(String processEngineName) {
        CommandExecutor commandExecutor = (CommandExecutor)this.commandExecutors.get(processEngineName);
        if (commandExecutor == null) {
            commandExecutor = this.createCommandExecutor(processEngineName);
            this.commandExecutors.put(processEngineName, commandExecutor);
        }
        return commandExecutor;
    }

    @Deprecated
    public PluginRegistry getPluginRegistry() {
        return new DefaultPluginRegistry(this.pluginRegistry);
    }

    protected List<String> getMappingFiles() {
        List cockpitPlugins = this.pluginRegistry.getPlugins();
        ArrayList<String> mappingFiles = new ArrayList<String>();
        for (CockpitPlugin plugin : cockpitPlugins) {
            mappingFiles.addAll(plugin.getMappingFiles());
        }
        return mappingFiles;
    }

    protected CommandExecutor createCommandExecutor(String processEngineName) {
        ProcessEngine processEngine = this.getProcessEngine(processEngineName);
        if (processEngine == null) {
            throw new ProcessEngineException("No process engine with name " + processEngineName + " found.");
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        List mappingFiles = this.getMappingFiles();
        return new CommandExecutorImpl(processEngineConfiguration, mappingFiles);
    }
}

