/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.webapp.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.Set;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.rest.spi.ProcessEngineProvider;
import org.eximeebpms.bpm.webapp.AppRuntimeDelegate;
import org.eximeebpms.bpm.webapp.plugin.AppPluginRegistry;
import org.eximeebpms.bpm.webapp.plugin.impl.DefaultAppPluginRegistry;
import org.eximeebpms.bpm.webapp.plugin.resource.PluginResourceOverride;
import org.eximeebpms.bpm.webapp.plugin.spi.AppPlugin;

public abstract class AbstractAppRuntimeDelegate<T extends AppPlugin>
implements AppRuntimeDelegate<T> {
    protected final AppPluginRegistry<T> pluginRegistry;
    protected final ProcessEngineProvider processEngineProvider;
    protected List<PluginResourceOverride> resourceOverrides;

    public AbstractAppRuntimeDelegate(Class<T> pluginType) {
        this.pluginRegistry = new DefaultAppPluginRegistry(pluginType);
        this.processEngineProvider = this.loadProcessEngineProvider();
    }

    public ProcessEngine getProcessEngine(String processEngineName) {
        try {
            return this.processEngineProvider.getProcessEngine(processEngineName);
        }
        catch (Exception e) {
            throw new ProcessEngineException("No process engine with name " + processEngineName + " found.", (Throwable)e);
        }
    }

    public Set<String> getProcessEngineNames() {
        return this.processEngineProvider.getProcessEngineNames();
    }

    public ProcessEngine getDefaultProcessEngine() {
        return this.processEngineProvider.getDefaultProcessEngine();
    }

    public AppPluginRegistry<T> getAppPluginRegistry() {
        return this.pluginRegistry;
    }

    protected ProcessEngineProvider loadProcessEngineProvider() {
        ServiceLoader<ProcessEngineProvider> loader = ServiceLoader.load(ProcessEngineProvider.class);
        try {
            return loader.iterator().next();
        }
        catch (NoSuchElementException e) {
            String message = String.format("No implementation for the %s spi found on classpath", ProcessEngineProvider.class.getName());
            throw new IllegalStateException(message, e);
        }
    }

    public List<PluginResourceOverride> getResourceOverrides() {
        if (this.resourceOverrides == null) {
            this.initResourceOverrides();
        }
        return this.resourceOverrides;
    }

    protected synchronized void initResourceOverrides() {
        if (this.resourceOverrides == null) {
            this.resourceOverrides = new ArrayList();
            List plugins = this.pluginRegistry.getPlugins();
            for (AppPlugin p : plugins) {
                this.resourceOverrides.addAll(p.getResourceOverrides());
            }
        }
    }
}

