/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.admin.impl.plugin.resources;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;
import org.eximeebpms.bpm.admin.impl.plugin.base.dto.MetricsAggregatedQueryDto;
import org.eximeebpms.bpm.admin.impl.plugin.base.dto.MetricsAggregatedResultDto;
import org.eximeebpms.bpm.admin.resource.AbstractAdminPluginResource;
import org.eximeebpms.bpm.engine.impl.metrics.util.MetricsUtil;
import org.eximeebpms.bpm.webapp.db.QueryParameters;

public class MetricsRestService
extends AbstractAdminPluginResource {
    public static final String PATH = "/metrics";
    public static final ObjectMapper objectMapper = new ObjectMapper();

    public MetricsRestService(String engineName) {
        super(engineName);
    }

    @GET
    @Path(value="/aggregated")
    @Produces(value={"application/json"})
    public List<MetricsAggregatedResultDto> getAggregatedMetrics(@Context UriInfo uriInfo) {
        MetricsAggregatedQueryDto queryDto = new MetricsAggregatedQueryDto(objectMapper, uriInfo.getQueryParameters());
        queryDto.validateAndPrepareQuery();
        boolean queryTaskUsers = queryDto.getMetrics().remove("unique-task-workers");
        ArrayList<MetricsAggregatedResultDto> result = new ArrayList<MetricsAggregatedResultDto>();
        if (!queryDto.getMetrics().isEmpty()) {
            result.addAll(this.getQueryService().executeQuery("selectMetricsAggregated", (QueryParameters)queryDto));
        }
        if (queryTaskUsers) {
            result.addAll(this.getQueryService().executeQuery("selectMetricsAggregatedTU", (QueryParameters)queryDto));
        }
        result.forEach(resultDto -> resultDto.setMetric(MetricsUtil.resolvePublicName((String)resultDto.getMetric())));
        return result;
    }
}

