/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.webapp.impl.security.filter;

import java.util.Map;
import org.eximeebpms.bpm.cockpit.Cockpit;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.webapp.impl.security.auth.Authentication;
import org.eximeebpms.bpm.webapp.impl.security.auth.Authentications;
import org.eximeebpms.bpm.webapp.impl.security.auth.UserAuthentication;
import org.eximeebpms.bpm.webapp.impl.security.filter.Authorization;
import org.eximeebpms.bpm.webapp.impl.security.filter.RequestAuthorizer;

public class ApplicationRequestAuthorizer
implements RequestAuthorizer {
    public Authorization authorize(Map<String, String> parameters) {
        Authentications authentications = Authentications.getCurrent();
        if (authentications == null) {
            return this.grantAnnonymous();
        }
        String engineName = parameters.get("engine");
        String appName = parameters.get("app");
        Authentication engineAuth = authentications.getAuthenticationForProcessEngine(engineName);
        if (engineAuth == null) {
            return this.grantAnnonymous();
        }
        ProcessEngine processEngine = Cockpit.getProcessEngine((String)engineName);
        if (processEngine == null) {
            return this.grantAnnonymous();
        }
        if (engineAuth instanceof UserAuthentication) {
            UserAuthentication userAuth = (UserAuthentication)engineAuth;
            if (userAuth.isAuthorizedForApp(appName)) {
                return Authorization.granted((Authentication)userAuth).forApplication(appName);
            }
            return Authorization.denied((Authentication)userAuth).forApplication(appName);
        }
        return Authorization.denied((Authentication)Authentication.ANONYMOUS);
    }

    private Authorization grantAnnonymous() {
        return Authorization.granted((Authentication)Authentication.ANONYMOUS);
    }
}

