/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.cockpit.impl.plugin.resources;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.eximeebpms.bpm.cockpit.db.QueryParameters;
import org.eximeebpms.bpm.cockpit.impl.plugin.base.dto.ProcessDefinitionStatisticsDto;
import org.eximeebpms.bpm.cockpit.impl.plugin.base.dto.query.ProcessDefinitionStatisticsQueryDto;
import org.eximeebpms.bpm.cockpit.impl.plugin.base.sub.resources.ProcessDefinitionResource;
import org.eximeebpms.bpm.cockpit.plugin.resource.AbstractPluginResource;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.rest.dto.CountResultDto;

public class ProcessDefinitionRestService
extends AbstractPluginResource {
    public static final String PATH = "/process-definition";

    public ProcessDefinitionRestService(String engineName) {
        super(engineName);
    }

    @Path(value="/{id}")
    public ProcessDefinitionResource getProcessDefinition(@PathParam(value="id") String id) {
        return new ProcessDefinitionResource(this.getProcessEngine().getName(), id);
    }

    @GET
    @Path(value="/statistics-count")
    @Produces(value={"application/json"})
    public CountResultDto getStatisticsCount(@Context UriInfo uriInfo) {
        ProcessDefinitionStatisticsQueryDto queryDto = new ProcessDefinitionStatisticsQueryDto((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        this.configureExecutionQuery(queryDto);
        long count = this.getQueryService().executeQueryRowCount("selectPDStatisticsCount", queryDto);
        return new CountResultDto(count);
    }

    @GET
    @Path(value="/statistics")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<ProcessDefinitionStatisticsDto> queryStatistics(@Context UriInfo uriInfo, @QueryParam(value="firstResult") Integer firstResult, @QueryParam(value="maxResults") Integer maxResults) {
        ProcessDefinitionStatisticsQueryDto queryDto = new ProcessDefinitionStatisticsQueryDto((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        this.configureExecutionQuery(queryDto);
        queryDto.setFirstResult(firstResult != null && firstResult >= 0 ? firstResult : 0);
        queryDto.setMaxResults(maxResults != null && maxResults > 0 ? maxResults : Integer.MAX_VALUE);
        return this.getQueryService().executeQuery("selectPDStatistics", queryDto);
    }

    protected void configureExecutionQuery(QueryParameters query) {
        this.configureAuthorizationCheck(query);
        this.configureTenantCheck(query);
        this.addPermissionCheck(query, (Resource)Resources.PROCESS_DEFINITION, "RES.KEY_", (Permission)Permissions.READ);
    }
}

