/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.webapp.impl.security.filter;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.webapp.impl.security.filter.CookieConfigurator;
import org.eximeebpms.bpm.webapp.impl.security.filter.util.CsrfConstants;
import org.eximeebpms.bpm.webapp.impl.util.ServletContextUtil;

public class CsrfPreventionFilter
implements Filter {
    private String randomClass = SecureRandom.class.getName();
    private Random randomSource;
    private URL targetOrigin;
    private int denyStatus = 403;
    protected final Set<String> entryPoints = new HashSet<String>();
    protected CookieConfigurator cookieConfigurator = new CookieConfigurator();

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            String customEntryPoints;
            String customDenyStatus;
            String newRandomClass = filterConfig.getInitParameter("randomClass");
            if (!this.isBlank(newRandomClass)) {
                this.setRandomClass(newRandomClass);
            }
            Class<?> clazz = Class.forName(this.randomClass);
            this.randomSource = (Random)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            String targetOrigin = filterConfig.getInitParameter("targetOrigin");
            if (!this.isBlank(targetOrigin)) {
                this.setTargetOrigin(targetOrigin);
            }
            if (!this.isBlank(customDenyStatus = filterConfig.getInitParameter("denyStatus"))) {
                this.setDenyStatus(Integer.parseInt(customDenyStatus));
            }
            if (!this.isBlank(customEntryPoints = filterConfig.getInitParameter("entryPoints"))) {
                this.setEntryPoints(customEntryPoints);
            }
            this.cookieConfigurator.parseParams(filterConfig);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException("Cannot instantiate CSRF Prevention filter: Random class not found.", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ServletException("Cannot instantiate CSRF Prevention filter: cannot instantiate provided Random class", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServletException("Cannot instantiate CSRF Prevention filter: cannot instantiate provided Random class", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ServletException("Cannot instantiate CSRF Prevention filter: cannot instantiate provided Random class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException("Cannot instantiate CSRF Prevention filter: Random class constructor not accessible", (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new ServletException("CSRFPreventionFilter: Could not read target origin URL: " + e.getMessage());
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!this.isNonModifyingRequest(request)) {
            boolean isTokenValid;
            boolean bl = isTokenValid = this.doSameOriginStandardHeadersVerification(request, response) && this.doTokenValidation(request, response);
            if (!isTokenValid) {
                return;
            }
        } else {
            this.setCSRFToken(request, response);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected boolean doTokenValidation(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        String tokenHeader = this.getCSRFTokenHeader(request);
        String tokenSession = (String)this.getCSRFTokenSession(session);
        boolean isValid = true;
        if (this.isBlank(tokenHeader)) {
            session.invalidate();
            response.setHeader("X-XSRF-TOKEN", "Required");
            response.sendError(this.getDenyStatus(), "CSRFPreventionFilter: Token provided via HTTP Header is absent/empty.");
            isValid = false;
        } else if (this.isBlank(tokenSession) || !tokenSession.equals(tokenHeader)) {
            session.invalidate();
            response.sendError(this.getDenyStatus(), "CSRFPreventionFilter: Invalid HTTP Header Token.");
            isValid = false;
        }
        return isValid;
    }

    protected boolean doSameOriginStandardHeadersVerification(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.getTargetOrigin() == null) {
            return true;
        }
        String source = request.getHeader("Origin");
        if (this.isBlank(source) && this.isBlank(source = request.getHeader("Referer"))) {
            response.sendError(403, "CSRFPreventionFilter: ORIGIN and REFERER request headers are not present.");
            return false;
        }
        URL sourceURL = new URL(source);
        if (!this.getTargetOrigin().getProtocol().equals(sourceURL.getProtocol()) || !this.getTargetOrigin().getHost().equals(sourceURL.getHost()) || this.getTargetOrigin().getPort() != sourceURL.getPort()) {
            response.sendError(403, String.format("CSRFPreventionFilter: Protocol/Host/Port does not fully match: (%s != %s) ", this.getTargetOrigin(), sourceURL));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCSRFToken(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        Object sessionMutex = this.getSessionMutex(session);
        if (session.getAttribute("EXIMEEBPMS_CSRF_TOKEN") == null) {
            Object object = sessionMutex;
            synchronized (object) {
                if (session.getAttribute("EXIMEEBPMS_CSRF_TOKEN") == null) {
                    String token = this.generateCSRFToken();
                    String cookieName = this.cookieConfigurator.getCookieName("XSRF-TOKEN");
                    String csrfCookieValue = cookieName + "=" + token;
                    String cookiePath = this.getCookiePath(request);
                    csrfCookieValue = csrfCookieValue + ";Path=" + cookiePath;
                    session.setAttribute("EXIMEEBPMS_CSRF_TOKEN", (Object)token);
                    csrfCookieValue = csrfCookieValue + this.cookieConfigurator.getConfig();
                    response.addHeader("Set-Cookie", csrfCookieValue);
                    response.setHeader("X-XSRF-TOKEN", token);
                }
            }
        }
    }

    protected String getCookiePath(HttpServletRequest request) {
        ServletContext servletContext = request.getServletContext();
        String applicationPath = ServletContextUtil.getAppPath(servletContext);
        String contextPath = request.getContextPath();
        String cookiePath = contextPath + applicationPath;
        if (!cookiePath.isEmpty()) {
            return cookiePath;
        }
        return "/";
    }

    public URL getTargetOrigin() {
        return this.targetOrigin;
    }

    public void setTargetOrigin(String targetOrigin) throws MalformedURLException {
        this.targetOrigin = new URL(targetOrigin);
    }

    public void setEntryPoints(String entryPoints) {
        this.entryPoints.addAll(this.parseURLs(entryPoints));
    }

    public int getDenyStatus() {
        return this.denyStatus;
    }

    public void setDenyStatus(int denyStatus) {
        this.denyStatus = denyStatus;
    }

    public String getRandomClass() {
        return this.randomClass;
    }

    public void setRandomClass(String randomClass) {
        this.randomClass = randomClass;
    }

    public void destroy() {
    }

    protected boolean isNonModifyingRequest(HttpServletRequest request) {
        return CsrfConstants.CSRF_NON_MODIFYING_METHODS_PATTERN.matcher(request.getMethod()).matches() || this.entryPoints.contains(this.getRequestedPath(request));
    }

    protected String generateCSRFToken() {
        byte[] random = new byte[16];
        StringBuilder buffer = new StringBuilder();
        this.randomSource.nextBytes(random);
        for (int j = 0; j < random.length; ++j) {
            byte b1 = (byte)((random[j] & 0xF0) >> 4);
            byte b2 = (byte)(random[j] & 0xF);
            if (b1 < 10) {
                buffer.append((char)(48 + b1));
            } else {
                buffer.append((char)(65 + (b1 - 10)));
            }
            if (b2 < 10) {
                buffer.append((char)(48 + b2));
                continue;
            }
            buffer.append((char)(65 + (b2 - 10)));
        }
        return buffer.toString();
    }

    private Object getCSRFTokenSession(HttpSession session) {
        return session.getAttribute("EXIMEEBPMS_CSRF_TOKEN");
    }

    private String getCSRFTokenHeader(HttpServletRequest request) {
        return request.getHeader("X-XSRF-TOKEN");
    }

    private Object getSessionMutex(HttpSession session) {
        if (session == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "HttpSession is missing");
        }
        Object mutex = session.getAttribute("EXIMEEBPMS_CSRF_SESSION_MUTEX");
        if (mutex == null) {
            mutex = session;
        }
        return mutex;
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    private String getRequestedPath(HttpServletRequest request) {
        Object path = request.getServletPath();
        if (request.getPathInfo() != null) {
            path = (String)path + request.getPathInfo();
        }
        return path;
    }

    private Set<String> parseURLs(String urlString) {
        HashSet<String> urlSet = new HashSet<String>();
        if (urlString != null && !urlString.isEmpty()) {
            String[] values;
            for (String value : values = urlString.split(",")) {
                urlSet.add(value.trim());
            }
        }
        return urlSet;
    }
}

