/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.webapp.plugin.resource;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eximeebpms.bpm.engine.rest.exception.RestException;
import org.eximeebpms.bpm.webapp.AppRuntimeDelegate;
import org.eximeebpms.bpm.webapp.plugin.resource.AbstractAppPluginResource;
import org.eximeebpms.bpm.webapp.plugin.resource.PluginResourceOverride;
import org.eximeebpms.bpm.webapp.plugin.resource.RequestInfo;
import org.eximeebpms.bpm.webapp.plugin.spi.AppPlugin;

public class AbstractAppPluginRootResource<T extends AppPlugin> {
    public static final String MIME_TYPE_TEXT_PLAIN = "text/plain";
    public static final String MIME_TYPE_TEXT_HTML = "text/html";
    public static final String MIME_TYPE_TEXT_CSS = "text/css";
    public static final String MIME_TYPE_TEXT_JAVASCRIPT = "text/javascript";
    @Context
    protected ServletContext servletContext;
    @Context
    protected HttpHeaders headers;
    @Context
    protected UriInfo uriInfo;
    private final String pluginName;
    protected AppRuntimeDelegate<T> runtimeDelegate;
    protected List<String> allowedAssets;

    public AbstractAppPluginRootResource(String pluginName, AppRuntimeDelegate<T> runtimeDelegate) {
        this.pluginName = pluginName;
        this.runtimeDelegate = runtimeDelegate;
        this.allowedAssets = this.getAllowedAssets();
    }

    protected List<String> getAllowedAssets() {
        ArrayList<String> assets = new ArrayList<String>();
        assets.add("app/plugin.js");
        assets.add("app/plugin.css");
        return assets;
    }

    protected <S extends AbstractAppPluginResource<T>> S subResource(S subResource, String engineName) {
        return subResource;
    }

    @GET
    @Path(value="/static/{file:.*}")
    public Response getAsset(@PathParam(value="file") String file) {
        if (!this.allowedAssets.contains(file)) {
            throw new RestException(Response.Status.FORBIDDEN, "Not allowed to load the following file '" + file + "'.");
        }
        AppPlugin plugin = this.runtimeDelegate.getAppPluginRegistry().getPlugin(this.pluginName);
        if (plugin != null) {
            InputStream assetStream = this.getPluginAssetAsStream(plugin, file);
            InputStream filteredStream = this.applyResourceOverrides(file, assetStream);
            if (assetStream != null) {
                String contentType = this.getContentType(file);
                return Response.ok((Object)new /* Unavailable Anonymous Inner Class!! */, (String)contentType).build();
            }
        }
        throw new RestException(Response.Status.NOT_FOUND, "It was not able to load the following file '" + file + "'.");
    }

    protected InputStream applyResourceOverrides(String file, InputStream assetStream) {
        ArrayList resourceOverrides = new ArrayList(this.runtimeDelegate.getResourceOverrides());
        for (PluginResourceOverride pluginResourceOverride : resourceOverrides) {
            assetStream = pluginResourceOverride.filterResource(assetStream, new RequestInfo(this.headers, this.servletContext, this.uriInfo));
        }
        return assetStream;
    }

    protected String getContentType(String file) {
        if (file.endsWith(".js")) {
            return MIME_TYPE_TEXT_JAVASCRIPT;
        }
        if (file.endsWith(".html")) {
            return MIME_TYPE_TEXT_HTML;
        }
        if (file.endsWith(".css")) {
            return MIME_TYPE_TEXT_CSS;
        }
        return MIME_TYPE_TEXT_PLAIN;
    }

    protected InputStream getPluginAssetAsStream(AppPlugin plugin, String fileName) {
        String assetDirectory = plugin.getAssetDirectory();
        if (assetDirectory == null) {
            return null;
        }
        InputStream result = this.getWebResourceAsStream(assetDirectory, fileName);
        if (result == null) {
            result = this.getClasspathResourceAsStream(plugin, assetDirectory, fileName);
        }
        return result;
    }

    protected InputStream getWebResourceAsStream(String assetDirectory, String fileName) {
        String resourceName = String.format("/%s/%s", assetDirectory, fileName);
        return this.servletContext.getResourceAsStream(resourceName);
    }

    protected InputStream getClasspathResourceAsStream(AppPlugin plugin, String assetDirectory, String fileName) {
        String resourceName = String.format("%s/%s", assetDirectory, fileName);
        return plugin.getClass().getClassLoader().getResourceAsStream(resourceName);
    }
}

