/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.admin.impl.plugin.resources;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.eximeebpms.bpm.admin.impl.plugin.base.dto.MetricsAggregatedQueryDto;
import org.eximeebpms.bpm.admin.impl.plugin.base.dto.MetricsAggregatedResultDto;
import org.eximeebpms.bpm.admin.resource.AbstractAdminPluginResource;
import org.eximeebpms.bpm.engine.impl.metrics.util.MetricsUtil;

public class MetricsRestService
extends AbstractAdminPluginResource {
    public static final String PATH = "/metrics";
    public static final ObjectMapper objectMapper = new ObjectMapper();

    public MetricsRestService(String engineName) {
        super(engineName);
    }

    @GET
    @Path(value="/aggregated")
    @Produces(value={"application/json"})
    public List<MetricsAggregatedResultDto> getAggregatedMetrics(@Context UriInfo uriInfo) {
        MetricsAggregatedQueryDto queryDto = new MetricsAggregatedQueryDto(objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        queryDto.validateAndPrepareQuery();
        boolean queryTaskUsers = queryDto.getMetrics().remove("unique-task-workers");
        ArrayList<MetricsAggregatedResultDto> result = new ArrayList<MetricsAggregatedResultDto>();
        if (!queryDto.getMetrics().isEmpty()) {
            result.addAll(this.getQueryService().executeQuery("selectMetricsAggregated", queryDto));
        }
        if (queryTaskUsers) {
            result.addAll(this.getQueryService().executeQuery("selectMetricsAggregatedTU", queryDto));
        }
        result.forEach(resultDto -> resultDto.setMetric(MetricsUtil.resolvePublicName((String)resultDto.getMetric())));
        return result;
    }
}

