/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.webapp.impl.security.filter;

import java.util.Map;
import org.eximeebpms.bpm.webapp.impl.security.filter.Authorization;
import org.eximeebpms.bpm.webapp.impl.security.filter.RequestAuthorizer;
import org.eximeebpms.bpm.webapp.impl.security.filter.RequestFilter;

public class RequestMatcher {
    private final RequestFilter filter;
    private final RequestAuthorizer authorizer;

    public RequestMatcher(RequestFilter filter, RequestAuthorizer authorizer) {
        this.filter = filter;
        this.authorizer = authorizer;
    }

    public Match match(String requestMethod, String requestUri) {
        Map<String, String> match = this.filter.match(requestMethod, requestUri);
        if (match != null) {
            return new Match(match, this.authorizer);
        }
        return null;
    }

    public static class Match {
        private final Map<String, String> parameters;
        private final RequestAuthorizer authorizer;

        public Match(Map<String, String> parameters, RequestAuthorizer authorizer) {
            this.parameters = parameters;
            this.authorizer = authorizer;
        }

        public Authorization authorize() {
            return this.authorizer.authorize(this.parameters);
        }
    }
}

