/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.webapp.impl.test.util;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.impl.ProcessEngineImpl;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobExecutor;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.runtime.Job;

public class JobExecutorHelper {
    private final ProcessEngineImpl processEngine;

    public JobExecutorHelper(ProcessEngine processEngine) {
        this.processEngine = (ProcessEngineImpl)processEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForJobExecutorToProcessAllJobs(long maxMillisToWait) {
        JobExecutor jobExecutor = this.getProcessEngineConfiguration().getJobExecutor();
        jobExecutor.start();
        long intervalMillis = 1000L;
        try {
            Timer timer = new Timer();
            InteruptTask task = new InteruptTask(Thread.currentThread());
            timer.schedule((TimerTask)task, maxMillisToWait);
            boolean areJobsAvailable = true;
            try {
                while (areJobsAvailable && !task.isTimeLimitExceeded()) {
                    Thread.sleep(intervalMillis);
                    try {
                        areJobsAvailable = this.areJobsAvailable();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                timer.cancel();
            }
            if (areJobsAvailable) {
                throw new ProcessEngineException("time limit of " + maxMillisToWait + " was exceeded");
            }
        }
        finally {
            jobExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForJobExecutorOnCondition(long maxMillisToWait, Callable<Boolean> condition) {
        JobExecutor jobExecutor = this.getProcessEngineConfiguration().getJobExecutor();
        jobExecutor.start();
        long intervalMillis = 1000L;
        try {
            Timer timer = new Timer();
            InteruptTask task = new InteruptTask(Thread.currentThread());
            timer.schedule((TimerTask)task, maxMillisToWait);
            boolean conditionIsViolated = true;
            try {
                while (conditionIsViolated && !task.isTimeLimitExceeded()) {
                    Thread.sleep(intervalMillis);
                    conditionIsViolated = condition.call() == false;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                throw new ProcessEngineException("Exception while waiting on condition: " + e.getMessage(), (Throwable)e);
            }
            finally {
                timer.cancel();
            }
            if (conditionIsViolated) {
                throw new ProcessEngineException("time limit of " + maxMillisToWait + " was exceeded");
            }
        }
        finally {
            jobExecutor.shutdown();
        }
    }

    public boolean areJobsAvailable() {
        List list = this.processEngine.getManagementService().createJobQuery().list();
        for (Job job : list) {
            if (job.getRetries() <= 0 || job.getDuedate() != null && !ClockUtil.getCurrentTime().after(job.getDuedate())) continue;
            return true;
        }
        return false;
    }

    private ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngine.getProcessEngineConfiguration();
    }

    private static class InteruptTask
    extends TimerTask {
        protected boolean timeLimitExceeded = false;
        protected Thread thread;

        public InteruptTask(Thread thread) {
            this.thread = thread;
        }

        public boolean isTimeLimitExceeded() {
            return this.timeLimitExceeded;
        }

        @Override
        public void run() {
            this.timeLimitExceeded = true;
            this.thread.interrupt();
        }
    }
}

