/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.webapp.impl.db;

import java.util.List;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.db.AuthorizationCheck;
import org.eximeebpms.bpm.engine.impl.db.ListQueryParameterObject;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.webapp.db.CommandExecutor;
import org.eximeebpms.bpm.webapp.db.QueryParameters;
import org.eximeebpms.bpm.webapp.db.QueryService;
import org.eximeebpms.bpm.webapp.impl.db.QueryServiceImpl;
import org.eximeebpms.bpm.webapp.impl.db.QuerySessionFactory;

public class QueryServiceImpl
implements QueryService {
    private CommandExecutor commandExecutor;

    public QueryServiceImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public <T> List<T> executeQuery(String statement, QueryParameters parameter) {
        return (List)this.commandExecutor.executeCommand((Command)new ExecuteListQueryCmd(this, statement, parameter));
    }

    public <T> T executeQuery(String statement, Object parameter, Class<T> clazz) {
        return (T)this.commandExecutor.executeCommand((Command)new ExecuteSingleQueryCmd(this, statement, parameter, clazz));
    }

    public Long executeQueryRowCount(String statement, ListQueryParameterObject parameter) {
        return (Long)this.commandExecutor.executeCommand((Command)new QueryServiceRowCountCmd(this, statement, parameter));
    }

    protected ProcessEngineConfigurationImpl getProcessEngineConfiguration(CommandContext commandContext) {
        QuerySessionFactory querySessionFactory = (QuerySessionFactory)commandContext.getProcessEngineConfiguration();
        ProcessEngineConfigurationImpl processEngineConfiguration = null;
        if (querySessionFactory != null) {
            processEngineConfiguration = querySessionFactory.getWrappedConfiguration();
        }
        if (processEngineConfiguration == null) {
            throw new ProcessEngineException("Process Engine Configuration missing!");
        }
        return processEngineConfiguration;
    }

    protected <T> void configureAuthCheck(ListQueryParameterObject parameter, ProcessEngineConfigurationImpl engineConfig, CommandContext commandContext) {
        AuthorizationCheck authCheck = parameter.getAuthCheck();
        commandContext.getAuthorizationManager().enableQueryAuthCheck(authCheck);
        boolean isEnableHistoricInstancePermissions = engineConfig.isEnableHistoricInstancePermissions();
        authCheck.setHistoricInstancePermissionsEnabled(isEnableHistoricInstancePermissions);
    }
}

