/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.webapp.impl.security.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eximeebpms.bpm.engine.AuthorizationService;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.identity.Group;
import org.eximeebpms.bpm.engine.identity.Tenant;
import org.eximeebpms.bpm.engine.identity.User;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.webapp.impl.WebappLogger;
import org.eximeebpms.bpm.webapp.impl.security.auth.Authentications;
import org.eximeebpms.bpm.webapp.impl.security.auth.UserAuthentication;
import org.eximeebpms.bpm.webapp.impl.util.ProcessEngineUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthenticationUtil {
    protected static final WebappLogger LOGGER = WebappLogger.INSTANCE;
    protected static final String CAM_AUTH_SESSION_KEY = "authenticatedUser";
    public static final String[] APPS = new String[]{"cockpit", "tasklist", "admin"};
    public static final String APP_WELCOME = "welcome";

    public static UserAuthentication createAuthentication(String engineName, String username) {
        return AuthenticationUtil.createAuthentication((String)engineName, (String)username, null, null);
    }

    public static UserAuthentication createAuthentication(ProcessEngine processEngine, String username) {
        return AuthenticationUtil.createAuthentication((ProcessEngine)processEngine, (String)username, null, null);
    }

    public static UserAuthentication createAuthentication(String engineName, String username, List<String> groupIds, List<String> tenantIds) {
        ProcessEngine processEngine = ProcessEngineUtil.lookupProcessEngine((String)engineName);
        if (processEngine == null) {
            throw LOGGER.invalidRequestEngineNotFoundForName(engineName);
        }
        return AuthenticationUtil.createAuthentication((ProcessEngine)processEngine, (String)username, groupIds, tenantIds);
    }

    public static UserAuthentication createAuthentication(ProcessEngine processEngine, String username, List<String> groupIds, List<String> tenantIds) {
        String userId = username;
        User user = (User)processEngine.getIdentityService().createUserQuery().userId(username).singleResult();
        if (user == null) {
            return null;
        }
        if (user.getId() != null && !user.getId().isEmpty()) {
            userId = user.getId();
        }
        processEngine.getIdentityService().clearAuthentication();
        if (groupIds == null) {
            groupIds = AuthenticationUtil.getGroupsOfUser((ProcessEngine)processEngine, (String)userId);
        }
        if (tenantIds == null) {
            tenantIds = AuthenticationUtil.getTenantsOfUser((ProcessEngine)processEngine, (String)userId);
        }
        AuthorizationService authorizationService = processEngine.getAuthorizationService();
        HashSet<String> authorizedApps = new HashSet<String>();
        authorizedApps.add("welcome");
        if (processEngine.getProcessEngineConfiguration().isAuthorizationEnabled()) {
            for (String application : APPS) {
                if (!AuthenticationUtil.isAuthorizedForApp((AuthorizationService)authorizationService, (String)userId, (List)groupIds, (String)application)) continue;
                authorizedApps.add(application);
            }
        } else {
            Collections.addAll(authorizedApps, APPS);
        }
        UserAuthentication newAuthentication = new UserAuthentication(userId, processEngine.getName());
        newAuthentication.setGroupIds(groupIds);
        newAuthentication.setTenantIds(tenantIds);
        newAuthentication.setAuthorizedApps(authorizedApps);
        return newAuthentication;
    }

    public static List<String> getTenantsOfUser(ProcessEngine engine, String userId) {
        List tenants = engine.getIdentityService().createTenantQuery().userMember(userId).includingGroupsOfUser(true).list();
        ArrayList<String> tenantIds = new ArrayList<String>();
        for (Tenant tenant : tenants) {
            if (tenant == null || tenant.getId() == null) continue;
            tenantIds.add(tenant.getId());
        }
        return tenantIds;
    }

    public static List<String> getGroupsOfUser(ProcessEngine engine, String userId) {
        List groups = engine.getIdentityService().createGroupQuery().groupMember(userId).list();
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group group : groups) {
            if (group == null || group.getId() == null) continue;
            groupIds.add(group.getId());
        }
        return groupIds;
    }

    protected static boolean isAuthorizedForApp(AuthorizationService authorizationService, String username, List<String> groupIds, String application) {
        return authorizationService.isUserAuthorized(username, groupIds, (Permission)Permissions.ACCESS, (Resource)Resources.APPLICATION, application);
    }

    public static Authentications getAuthsFromSession(HttpSession session) {
        Authentications authentications = (Authentications)session.getAttribute("authenticatedUser");
        if (authentications == null) {
            authentications = new Authentications();
            session.setAttribute("authenticatedUser", (Object)authentications);
        }
        return authentications;
    }

    public static void revalidateSession(HttpServletRequest request, UserAuthentication authentication) {
        HttpSession session = request.getSession();
        Authentications authentications = AuthenticationUtil.getAuthsFromSession((HttpSession)session);
        session.invalidate();
        session = request.getSession(true);
        if (authentication != null) {
            authentications.addOrReplace(authentication);
            session.setAttribute("authenticatedUser", (Object)authentications);
        }
    }

    public static void updateSession(HttpSession session, Authentications authentications) {
        if (session != null) {
            session.setAttribute("authenticatedUser", (Object)authentications);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCache(Authentications authentications, HttpSession session, long cacheTimeToLive) {
        Object object = AuthenticationUtil.getSessionMutex((HttpSession)session);
        synchronized (object) {
            for (UserAuthentication authentication : authentications.getAuthentications()) {
                Date cacheValidationTime = authentication.getCacheValidationTime();
                if (cacheValidationTime != null && !ClockUtil.getCurrentTime().after(cacheValidationTime)) continue;
                String userId = authentication.getIdentityId();
                String engineName = authentication.getProcessEngineName();
                UserAuthentication updatedAuth = AuthenticationUtil.createAuthentication((String)engineName, (String)userId);
                if (updatedAuth != null) {
                    if (cacheTimeToLive > 0L) {
                        Date newCacheValidationTime = new Date(ClockUtil.getCurrentTime().getTime() + cacheTimeToLive);
                        updatedAuth.setCacheValidationTime(newCacheValidationTime);
                        LOGGER.traceCacheValidationTimeUpdated(cacheValidationTime, newCacheValidationTime);
                    }
                    LOGGER.traceAuthenticationUpdated(engineName);
                    authentications.addOrReplace(updatedAuth);
                    continue;
                }
                authentications.removeByEngineName(engineName);
                LOGGER.traceAuthenticationRemoved(engineName);
            }
        }
    }

    protected static Object getSessionMutex(HttpSession session) {
        Object mutex = session.getAttribute("CAMUNDA_AUTH_TIME_SESSION_MUTEX");
        if (mutex == null) {
            mutex = session;
        }
        return mutex;
    }
}

