/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.webapp.impl.security.filter;

import java.util.Arrays;
import javax.servlet.FilterConfig;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.webapp.impl.security.filter.CookieConfigurator;
import org.eximeebpms.bpm.webapp.impl.security.filter.util.CookieConstants;
import org.eximeebpms.bpm.webapp.impl.util.ServletFilterUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class CookieConfigurator {
    protected static final String ENABLE_SECURE_PARAM = "enableSecureCookie";
    protected static final String ENABLE_SAME_SITE_PARAM = "enableSameSiteCookie";
    protected static final String SAME_SITE_OPTION_PARAM = "sameSiteCookieOption";
    protected static final String SAME_SITE_VALUE_PARAM = "sameSiteCookieValue";
    protected boolean isSecureCookieEnabled;
    protected boolean isSameSiteCookieEnabled;
    protected String sameSiteCookieValue;
    protected String cookieName;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseParams(FilterConfig filterConfig) {
        String enableSameSiteCookie;
        String cookieNameInput;
        String enableSecureCookie = filterConfig.getInitParameter("enableSecureCookie");
        if (!ServletFilterUtil.isEmpty((String)enableSecureCookie)) {
            this.isSecureCookieEnabled = Boolean.parseBoolean(enableSecureCookie);
        }
        if (!this.isBlank(cookieNameInput = filterConfig.getInitParameter("cookieName"))) {
            this.cookieName = cookieNameInput;
        }
        this.isSameSiteCookieEnabled = !ServletFilterUtil.isEmpty((String)(enableSameSiteCookie = filterConfig.getInitParameter("enableSameSiteCookie"))) ? Boolean.parseBoolean(enableSameSiteCookie) : true;
        String sameSiteCookieValue = filterConfig.getInitParameter("sameSiteCookieValue");
        String sameSiteCookieOption = filterConfig.getInitParameter("sameSiteCookieOption");
        if (!ServletFilterUtil.isEmpty((String)sameSiteCookieValue) && !ServletFilterUtil.isEmpty((String)sameSiteCookieOption)) {
            throw new ProcessEngineException("Please either configure sameSiteCookieOption or sameSiteCookieValue.");
        }
        if (!ServletFilterUtil.isEmpty((String)sameSiteCookieValue)) {
            this.sameSiteCookieValue = sameSiteCookieValue;
            return;
        } else if (!ServletFilterUtil.isEmpty((String)sameSiteCookieOption)) {
            if (SameSiteOption.LAX.compareTo(sameSiteCookieOption)) {
                this.sameSiteCookieValue = SameSiteOption.LAX.getValue();
                return;
            } else {
                if (!SameSiteOption.STRICT.compareTo(sameSiteCookieOption)) throw new ProcessEngineException("For sameSiteCookieOption param, please configure one of the following options: " + Arrays.toString(SameSiteOption.values()));
                this.sameSiteCookieValue = SameSiteOption.STRICT.getValue();
            }
            return;
        } else {
            this.sameSiteCookieValue = SameSiteOption.LAX.getValue();
        }
    }

    public String getConfig() {
        return this.getConfig(null);
    }

    public String getConfig(String currentHeader) {
        StringBuilder stringBuilder = new StringBuilder(currentHeader == null ? "" : currentHeader);
        if (this.isSameSiteCookieEnabled && (currentHeader == null || !CookieConstants.SAME_SITE_FIELD_NAME_REGEX.matcher(currentHeader).find())) {
            stringBuilder.append(";SameSite=").append(this.sameSiteCookieValue);
        }
        if (this.isSecureCookieEnabled && (currentHeader == null || !CookieConstants.SECURE_FLAG_NAME_REGEX.matcher(currentHeader).find())) {
            stringBuilder.append(";Secure");
        }
        return stringBuilder.toString();
    }

    public String getCookieName(String defaultName) {
        return this.isBlank(this.cookieName) ? defaultName : this.cookieName;
    }

    protected boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }
}

