/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.webapp.impl.security.auth;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.identity.Group;
import org.eximeebpms.bpm.engine.identity.Tenant;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.webapp.impl.WebappLogger;
import org.eximeebpms.bpm.webapp.impl.security.auth.Authentication;
import org.eximeebpms.bpm.webapp.impl.security.auth.AuthenticationDto;
import org.eximeebpms.bpm.webapp.impl.security.auth.AuthenticationUtil;
import org.eximeebpms.bpm.webapp.impl.security.auth.Authentications;
import org.eximeebpms.bpm.webapp.impl.security.auth.UserAuthentication;
import org.eximeebpms.bpm.webapp.impl.util.ProcessEngineUtil;
import org.eximeebpms.bpm.webapp.impl.util.ServletContextUtil;

@Path(value="/auth/user")
public class UserAuthenticationResource {
    protected static final WebappLogger LOGGER = WebappLogger.INSTANCE;
    public static final String PATH = "/auth/user";
    @Context
    protected HttpServletRequest request;

    @GET
    @Path(value="/{processEngineName}")
    public Response getAuthenticatedUser(@PathParam(value="processEngineName") String engineName) {
        Authentications allAuthentications = Authentications.getCurrent();
        if (allAuthentications == null) {
            return this.notFound();
        }
        Authentication engineAuth = allAuthentications.getAuthenticationForProcessEngine(engineName);
        if (engineAuth == null) {
            return this.notFound();
        }
        return Response.ok((Object)AuthenticationDto.fromAuthentication((Authentication)engineAuth)).build();
    }

    @POST
    @Path(value="/{processEngineName}/login/{appName}")
    public Response doLogin(@PathParam(value="processEngineName") String engineName, @PathParam(value="appName") String appName, @FormParam(value="username") String username, @FormParam(value="password") String password) {
        Set authorizedApps;
        ProcessEngine processEngine = ProcessEngineUtil.lookupProcessEngine((String)engineName);
        if (processEngine == null) {
            throw LOGGER.invalidRequestEngineNotFoundForName(engineName);
        }
        processEngine.getIdentityService().clearAuthentication();
        boolean isPasswordValid = processEngine.getIdentityService().checkPassword(username, password);
        if (!isPasswordValid) {
            if (this.isWebappsAuthenticationLoggingEnabled(processEngine)) {
                LOGGER.infoWebappFailedLogin(username, "bad credentials");
            }
            return this.unauthorized();
        }
        UserAuthentication authentication = AuthenticationUtil.createAuthentication((ProcessEngine)processEngine, (String)username);
        if (authentication == null) {
            if (this.isWebappsAuthenticationLoggingEnabled(processEngine)) {
                LOGGER.infoWebappFailedLogin(username, "not authorized");
            }
            return this.unauthorized();
        }
        ServletContext servletContext = this.request.getServletContext();
        Date cacheValidationTime = ServletContextUtil.getAuthCacheValidationTime((ServletContext)servletContext);
        if (cacheValidationTime != null) {
            LOGGER.traceCacheValidationTime(cacheValidationTime);
            authentication.setCacheValidationTime(cacheValidationTime);
        }
        if (!(authorizedApps = authentication.getAuthorizedApps()).contains(appName)) {
            if (this.isWebappsAuthenticationLoggingEnabled(processEngine)) {
                LOGGER.infoWebappFailedLogin(username, "not authorized");
            }
            return this.forbidden();
        }
        if (this.request != null) {
            AuthenticationUtil.revalidateSession((HttpServletRequest)this.request, (UserAuthentication)authentication);
        }
        if (this.isWebappsAuthenticationLoggingEnabled(processEngine)) {
            LOGGER.infoWebappSuccessfulLogin(username);
        }
        return Response.ok((Object)AuthenticationDto.fromAuthentication((Authentication)authentication)).build();
    }

    protected List<String> getGroupsOfUser(ProcessEngine engine, String userId) {
        List groups = engine.getIdentityService().createGroupQuery().groupMember(userId).list();
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group group : groups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }

    protected List<String> getTenantsOfUser(ProcessEngine engine, String userId) {
        List tenants = engine.getIdentityService().createTenantQuery().userMember(userId).includingGroupsOfUser(true).list();
        ArrayList<String> tenantIds = new ArrayList<String>();
        for (Tenant tenant : tenants) {
            tenantIds.add(tenant.getId());
        }
        return tenantIds;
    }

    @POST
    @Path(value="/{processEngineName}/logout")
    public Response doLogout(@PathParam(value="processEngineName") String engineName) {
        Authentications authentications = Authentications.getCurrent();
        ProcessEngine processEngine = ProcessEngineUtil.lookupProcessEngine((String)engineName);
        if (processEngine == null) {
            throw LOGGER.invalidRequestEngineNotFoundForName(engineName);
        }
        if (authentications != null) {
            UserAuthentication removedAuthentication = authentications.removeByEngineName(engineName);
            if (this.isWebappsAuthenticationLoggingEnabled(processEngine) && removedAuthentication != null) {
                LOGGER.infoWebappLogout(removedAuthentication.getName());
            }
        }
        return Response.ok().build();
    }

    protected Response unauthorized() {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    protected Response forbidden() {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    protected Response notFound() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private boolean isWebappsAuthenticationLoggingEnabled(ProcessEngine processEngine) {
        return ((ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration()).isWebappsAuthenticationLoggingEnabled();
    }
}

