/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.webapp.impl.security.filter;

import java.util.ArrayList;
import java.util.List;
import org.eximeebpms.bpm.webapp.impl.security.auth.Authentication;
import org.eximeebpms.bpm.webapp.impl.security.filter.Authorization;
import org.eximeebpms.bpm.webapp.impl.security.filter.RequestMatcher;
import org.eximeebpms.bpm.webapp.impl.security.filter.SecurityFilterRule;

public class PathFilterRule
implements SecurityFilterRule {
    protected List<RequestMatcher> allowedPaths = new ArrayList();
    protected List<RequestMatcher> deniedPaths = new ArrayList();

    public Authorization authorize(String requestMethod, String requestUri) {
        RequestMatcher.Match match;
        boolean secured = false;
        for (RequestMatcher pattern : this.deniedPaths) {
            match = pattern.match(requestMethod, requestUri);
            if (match == null) continue;
            secured = true;
            break;
        }
        if (!secured) {
            return Authorization.granted((Authentication)Authentication.ANONYMOUS);
        }
        for (RequestMatcher pattern : this.allowedPaths) {
            match = pattern.match(requestMethod, requestUri);
            if (match == null) continue;
            return match.authorize();
        }
        return null;
    }

    public List<RequestMatcher> getAllowedPaths() {
        return this.allowedPaths;
    }

    public List<RequestMatcher> getDeniedPaths() {
        return this.deniedPaths;
    }
}

