/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.webapp.impl.security.filter;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eximeebpms.bpm.engine.impl.util.IoUtil;
import org.eximeebpms.bpm.webapp.impl.security.auth.Authentications;
import org.eximeebpms.bpm.webapp.impl.security.filter.Authorization;
import org.eximeebpms.bpm.webapp.impl.security.filter.SecurityFilterRule;
import org.eximeebpms.bpm.webapp.impl.security.filter.util.FilterRules;
import org.eximeebpms.bpm.webapp.impl.util.ServletContextUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class SecurityFilter
implements Filter {
    public List<SecurityFilterRule> filterRules = new ArrayList();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilterSecure((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    public void doFilterSecure(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestUri = this.getRequestUri(request);
        Authorization authorization = SecurityFilter.authorize((String)request.getMethod(), (String)requestUri, (List)this.filterRules);
        authorization.attachHeaders(response);
        if (authorization.isGranted()) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else if (authorization.isAuthenticated()) {
            String application = authorization.getApplication();
            if (application != null) {
                this.sendForbiddenApplicationAccess(application, request, response);
            } else {
                this.sendForbidden(request, response);
            }
        } else {
            this.sendUnauthorized(request, response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext servletContext = filterConfig.getServletContext();
        String applicationPath = ServletContextUtil.getAppPath((ServletContext)servletContext);
        this.loadFilterRules(filterConfig, applicationPath);
    }

    public void destroy() {
    }

    public static Authorization authorize(String requestMethod, String requestUri, List<SecurityFilterRule> filterRules) {
        return FilterRules.authorize((String)requestMethod, (String)requestUri, filterRules);
    }

    protected void loadFilterRules(FilterConfig filterConfig, String applicationPath) throws ServletException {
        String configFileName = filterConfig.getInitParameter("configFile");
        InputStream configFileResource = filterConfig.getServletContext().getResourceAsStream(configFileName);
        if (configFileResource == null) {
            throw new ServletException("Could not read security filter config file '" + configFileName + "': no such resource in servlet context.");
        }
        try {
            this.filterRules = FilterRules.load((InputStream)configFileResource, (String)applicationPath);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while parsing '" + configFileName + "'", e);
        }
        finally {
            IoUtil.closeSilently((Closeable)configFileResource);
        }
    }

    protected void sendForbidden(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(403);
    }

    protected void sendUnauthorized(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(401);
    }

    protected void sendForbiddenApplicationAccess(String application, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(403, "No access rights for " + application);
    }

    protected boolean isAuthenticated(HttpServletRequest request) {
        return Authentications.getCurrent() != null;
    }

    protected String getRequestUri(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        return request.getRequestURI().substring(contextPath.length());
    }
}

