/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.beans;

import org.exparity.beans.core.BeanPropertyPredicate;
import org.exparity.beans.core.predicates.HasType;
import org.exparity.beans.core.predicates.MatchersPattern;
import org.exparity.beans.core.predicates.MatchesAll;
import org.exparity.beans.core.predicates.MatchesAlways;
import org.exparity.beans.core.predicates.MatchesOneOf;
import org.exparity.beans.core.predicates.Named;
import org.exparity.beans.core.predicates.OfDeclaringType;
import org.exparity.beans.core.predicates.WithPropertyValue;
import org.exparity.beans.core.predicates.WithValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanPredicates {
    public static BeanPropertyPredicate matchesAll(BeanPropertyPredicate ... predicates) {
        return new MatchesAll(predicates);
    }

    public static BeanPropertyPredicate matchesOneOf(BeanPropertyPredicate ... predicates) {
        return new MatchesOneOf(predicates);
    }

    public static BeanPropertyPredicate anyProperty() {
        return new MatchesAlways();
    }

    public static BeanPropertyPredicate named(String name) {
        return new Named(name);
    }

    public static BeanPropertyPredicate hasValue(Object value) {
        return new WithValue(value);
    }

    public static BeanPropertyPredicate hasPropertyValue(String name, Object value) {
        return new WithPropertyValue(value, name);
    }

    public static BeanPropertyPredicate ofType(Class<?> ... types) {
        return new HasType(types);
    }

    public static BeanPropertyPredicate matchesPattern(String name, String pattern) {
        return new MatchersPattern(name, pattern);
    }

    public static BeanPropertyPredicate ofDeclaringType(Class<?> ... types) {
        return new OfDeclaringType(types);
    }

    public static BeanPropertyPredicate named(String propertyName, Class<?> ... types) {
        return BeanPredicates.matchesAll(BeanPredicates.named(propertyName), BeanPredicates.ofType(types));
    }
}

