/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.beans.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.exparity.beans.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProperty {
    private final Class<?> declaringType;
    private final String name;
    private final Type type;
    private final Class<?>[] params;

    protected AbstractProperty(Class<?> declaringType, String name, Type type, Class<?>[] params) {
        this.declaringType = declaringType;
        this.name = name;
        this.type = type;
        this.params = params;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasName(String name) {
        return StringUtils.equalsIgnoreCase((String)name, (String)this.name);
    }

    public Class<?> getDeclaringType() {
        return this.declaringType;
    }

    public String getDeclaringTypeCanonicalName() {
        return this.declaringType.getCanonicalName();
    }

    public String getDeclaringTypeSimpleName() {
        return this.declaringType.getSimpleName();
    }

    public Class<?> getType() {
        return this.type.getType();
    }

    public String getTypeCanonicalName() {
        return this.type.canonicalName();
    }

    public String getTypeSimpleName() {
        return this.type.simpleName();
    }

    public Class<?> getTypeParameter(int n) {
        if (this.params.length > n) {
            return this.params[n];
        }
        throw new IllegalArgumentException("Unknown type parameter with index '" + n + "'");
    }

    public List<Class<?>> getTypeParameters() {
        return Arrays.asList(this.params);
    }

    public boolean hasAnyTypeParameters(Class<?> ... types) {
        for (Class<?> type : types) {
            for (Class<?> param : this.params) {
                if (!type.isAssignableFrom(param)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasTypeParameter(Class<?> type) {
        for (Class<?> param : this.params) {
            if (!type.isAssignableFrom(param)) continue;
            return true;
        }
        return false;
    }

    public boolean isIterable() {
        return this.isType((Class<?>)Iterable.class);
    }

    public boolean isType(Class<?> type) {
        return this.type.is(type);
    }

    public boolean isType(Class<?> ... types) {
        for (Class<?> type : types) {
            if (!this.type.is(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isGeneric() {
        return this.params.length > 0;
    }

    public boolean isPrimitive() {
        return this.type.isPrimitive();
    }

    public boolean isArray() {
        return this.type.isArray();
    }

    public boolean isString() {
        return this.isType((Class<?>)String.class);
    }

    public boolean isCharacter() {
        return this.isType(Character.class, Character.TYPE);
    }

    public boolean isByte() {
        return this.isType(Byte.class, Byte.TYPE);
    }

    public boolean isInteger() {
        return this.isType(Integer.class, Integer.TYPE);
    }

    public boolean isDouble() {
        return this.isType(Double.class, Double.TYPE);
    }

    public boolean isFloat() {
        return this.isType(Float.class, Float.TYPE);
    }

    public boolean isShort() {
        return this.isType(Short.class, Short.TYPE);
    }

    public boolean isLong() {
        return this.isType(Long.class, Long.TYPE);
    }

    public boolean isBoolean() {
        return this.isType(Boolean.class, Boolean.TYPE);
    }

    public boolean isDate() {
        return this.isType((Class<?>)Date.class);
    }

    public boolean isMap() {
        return this.isType((Class<?>)Map.class);
    }

    public boolean isList() {
        return this.isType((Class<?>)List.class);
    }

    public boolean isSet() {
        return this.isType((Class<?>)Set.class);
    }

    public boolean isCollection() {
        return this.isType((Class<?>)Collection.class);
    }

    public boolean isEnum() {
        return this.type.isEnum();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(obj.getClass())) {
            return false;
        }
        AbstractProperty rhs = (AbstractProperty)obj;
        return new EqualsBuilder().append(this.declaringType, rhs.declaringType).append((Object)this.name, (Object)rhs.name).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(23, 35).append(this.declaringType).append((Object)this.name).toHashCode();
    }

    public String toString() {
        return this.getClass() + "[" + this.declaringType + "." + this.name + "]";
    }
}

