/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.beans.core;

import java.lang.reflect.Method;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.exparity.beans.Type;
import org.exparity.beans.core.AbstractProperty;
import org.exparity.beans.core.MethodWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanProperty
extends AbstractProperty {
    private final Object instance;
    private final MethodWrapper accessor;
    private final MethodWrapper mutator;

    BeanProperty(String propertyName, MethodWrapper accessor, MethodWrapper mutator, Object instance) {
        super(accessor.getDeclaringClass(), propertyName, Type.type(accessor.getReturnType()), accessor.genericArgs());
        this.instance = instance;
        this.accessor = accessor;
        this.mutator = mutator;
    }

    public Object getInstance() {
        return this.instance;
    }

    public Method getAccessor() {
        return this.accessor.getMethod();
    }

    public Method getMutator() {
        return this.mutator.getMethod();
    }

    public <T> T getValue(Class<T> type) {
        return (T)this.getValue();
    }

    public Object getValue() {
        return this.accessor.invoke(this.instance);
    }

    public boolean hasValue(Object value) {
        return value == null ? this.isNull() : value.equals(this.getValue());
    }

    public boolean isNull() {
        return this.getValue() == null;
    }

    public boolean setValue(Object value) {
        return this.mutator.invoke(this.instance, value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BeanProperty)) {
            return false;
        }
        BeanProperty rhs = (BeanProperty)obj;
        return new EqualsBuilder().append(this.getDeclaringType(), rhs.getDeclaringType()).append((Object)this.getName(), (Object)rhs.getName()).append(this.instance, rhs.instance).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(23, 35).append(this.getDeclaringType()).append((Object)this.getName()).append(this.instance).toHashCode();
    }

    @Override
    public String toString() {
        return "BeanProperty [" + this.getDeclaringType() + "." + this.getName() + " [" + this.instance + "]]";
    }
}

