/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.beans.core;

import org.apache.commons.lang.StringUtils;

public class BeanPropertyPath {
    private static final String INDEX_PATTERN = "\\[\\w*\\]\\.";
    private static final String PATH_SEPERATOR = ".";
    private final String path;

    public BeanPropertyPath(String path) {
        this.path = path;
    }

    public BeanPropertyPath append(String name) {
        return StringUtils.isBlank((String)this.path) ? new BeanPropertyPath(name) : new BeanPropertyPath(this.path + PATH_SEPERATOR + name);
    }

    public BeanPropertyPath appendIndex(String index) {
        return new BeanPropertyPath(this.path + "[" + index + "]");
    }

    public BeanPropertyPath appendIndex(int index) {
        return new BeanPropertyPath(this.path + "[" + index + "]");
    }

    public String fullPathWithNoIndexes() {
        return this.path.replaceAll(INDEX_PATTERN, PATH_SEPERATOR);
    }

    public boolean startsWith(String prefix) {
        return this.fullPathWithNoIndexes().startsWith(prefix);
    }

    public String fullPath() {
        return this.path;
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty((String)this.path);
    }

    public Integer depth() {
        return StringUtils.countMatches((String)this.path, (String)PATH_SEPERATOR);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BeanPropertyPath)) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((String)((BeanPropertyPath)obj).path, (String)this.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return "PropertyPath [" + this.path + "]";
    }
}

