/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.beans.core;

import java.lang.reflect.Method;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.exparity.beans.Type;
import org.exparity.beans.core.AbstractProperty;
import org.exparity.beans.core.MethodWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeProperty
extends AbstractProperty {
    private final MethodWrapper accessor;
    private final MethodWrapper mutator;

    TypeProperty(String propertyName, MethodWrapper accessor, MethodWrapper mutator) {
        super(accessor.getDeclaringClass(), propertyName, Type.type(accessor.getReturnType()), accessor.genericArgs());
        this.accessor = accessor;
        this.mutator = mutator;
    }

    public Method getAccessor() {
        return this.accessor.getMethod();
    }

    MethodWrapper getAccessorWrapper() {
        return this.accessor;
    }

    public Method getMutator() {
        return this.mutator.getMethod();
    }

    MethodWrapper getMutatorWrapper() {
        return this.mutator;
    }

    public Object getValue(Object instance) {
        return this.accessor.invoke(instance);
    }

    public <T> T getValue(Object instance, Class<T> type) {
        return (T)this.getValue(instance);
    }

    public boolean setValue(Object instance, Object value) {
        return this.mutator.invoke(instance, value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TypeProperty)) {
            return false;
        }
        TypeProperty rhs = (TypeProperty)obj;
        return new EqualsBuilder().append(this.getDeclaringType(), rhs.getDeclaringType()).append((Object)this.getName(), (Object)rhs.getName()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(23, 35).append(this.getDeclaringType()).append((Object)this.getName()).toHashCode();
    }

    @Override
    public String toString() {
        return "TypeProperty [" + this.getDeclaringType() + "." + this.getName() + "]";
    }
}

