/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.beans.core;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.exparity.beans.Type;
import org.exparity.beans.core.BeanNamingStrategy;
import org.exparity.beans.core.BeanProperty;
import org.exparity.beans.core.BeanPropertyPath;
import org.exparity.beans.core.BeanVisitor;
import org.exparity.beans.core.TypeProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceInspector {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceInspector.class);
    private static final Integer OBJECT_HITS_BEFORE_OVERFLOW = 0;
    private final ThreadLocal<Map<Object, Integer>> inspected = new ThreadLocal<Map<Object, Integer>>(){

        @Override
        protected Map<Object, Integer> initialValue() {
            return new HashMap<Object, Integer>();
        }
    };
    private final InspectionDepth depth;
    private final Overflow overflow;

    public static InstanceInspector beanInspector() {
        return new InstanceInspector(InspectionDepth.BEAN, Overflow.DENY_OVERFLOW);
    }

    public static InstanceInspector graphInspector() {
        return new InstanceInspector(InspectionDepth.GRAPH, Overflow.DENY_OVERFLOW);
    }

    InstanceInspector(InspectionDepth depth, Overflow overflow) {
        this.depth = depth;
        this.overflow = overflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inspect(Object instance, BeanNamingStrategy naming, BeanVisitor visitor) {
        try {
            if (instance != null) {
                this.inspectObject(new ArrayList<Object>(), new BeanPropertyPath(naming.describeRoot(instance.getClass())), naming, instance, visitor, new AtomicBoolean());
            }
        }
        finally {
            this.inspected.get().clear();
        }
    }

    private void inspectObject(List<Object> currentStack, BeanPropertyPath path, BeanNamingStrategy naming, Object instance, BeanVisitor visitor, AtomicBoolean stop) {
        if (instance == null) {
            return;
        }
        if (stop.get()) {
            LOG.debug("Stopped Visit of {}. Stop set to true", (Object)path);
        }
        ArrayList<Object> stack = new ArrayList<Object>(currentStack);
        this.logInspection(path, "Object", instance);
        if (this.isDenyOverflow()) {
            int instanceKey = System.identityHashCode(instance);
            Integer hits = this.inspected.get().get(instanceKey);
            if (hits != null) {
                if (hits > OBJECT_HITS_BEFORE_OVERFLOW) {
                    return;
                }
                hits = hits + 1;
                this.inspected.get().put(instanceKey, hits);
            } else {
                this.inspected.get().put(instanceKey, 1);
            }
        }
        if (!this.isInspectChildren() && currentStack.size() > 0) {
            return;
        }
        Type type = Type.type(instance.getClass(), naming);
        if (type.isArray()) {
            this.inspectArray(new ArrayList<Object>(), path, naming, instance, visitor, stop);
        } else if (type.is(Iterable.class)) {
            this.inspectIterable(new ArrayList<Object>(), path, naming, (Iterable)instance, visitor, stop);
        } else if (type.is(Map.class)) {
            this.inspectMap(new ArrayList<Object>(), path, naming, (Map)instance, visitor, stop);
        } else {
            BeanPropertyPath rootPath = path.isEmpty() ? new BeanPropertyPath(naming.describeType(instance.getClass())) : path;
            stack.add(instance);
            for (TypeProperty property : type.propertyList()) {
                Object value;
                BeanPropertyPath nextPath = rootPath.append(property.getName());
                visitor.visit(new BeanProperty(property.getName(), nextPath, property.getAccessorWrapper(), property.getMutatorWrapper(), instance), instance, stack.toArray(), stop);
                if (stop.get()) {
                    LOG.debug("Stopped Visit of {}. Stop set to true", (Object)nextPath);
                    return;
                }
                if (property.isArray()) {
                    value = property.getValue(instance);
                    if (value == null) continue;
                    this.inspectArray(stack, nextPath, naming, value, visitor, stop);
                    continue;
                }
                if (property.isIterable()) {
                    value = property.getValue(instance, Iterable.class);
                    if (value == null) continue;
                    this.inspectIterable((List<Object>)stack, nextPath, naming, (Iterable<?>)value, visitor, stop);
                    continue;
                }
                if (property.isMap()) {
                    value = property.getValue(instance, Map.class);
                    if (value == null) continue;
                    this.inspectMap((List<Object>)stack, nextPath, naming, (Map<?, ?>)value, visitor, stop);
                    continue;
                }
                try {
                    Object propertyValue = property.getValue(instance);
                    if (propertyValue == null) continue;
                    this.inspectObject(stack, nextPath, naming, propertyValue, visitor, stop);
                }
                catch (Exception e) {
                    LOG.trace("Skip {}. Exception thrown on calling get", (Object)property);
                }
            }
        }
    }

    private boolean isDenyOverflow() {
        return Overflow.DENY_OVERFLOW.equals((Object)this.overflow);
    }

    private boolean isInspectChildren() {
        return InspectionDepth.GRAPH.equals((Object)this.depth);
    }

    private void inspectMap(List<Object> stack, BeanPropertyPath path, BeanNamingStrategy naming, Map<?, ?> instance, BeanVisitor visitor, AtomicBoolean stop) {
        this.logInspection(path, "Map", instance);
        for (Map.Entry<?, ?> entry : instance.entrySet()) {
            BeanPropertyPath nextPath = path.isEmpty() ? new BeanPropertyPath(naming.describeType(Map.class)) : path;
            this.inspectObject(stack, nextPath.appendIndex(entry.getKey().toString()), naming, entry.getValue(), visitor, stop);
        }
    }

    private void inspectArray(List<Object> stack, BeanPropertyPath path, BeanNamingStrategy naming, Object instance, BeanVisitor visitor, AtomicBoolean stop) {
        this.logInspection(path, "Array", instance);
        for (int i = 0; i < Array.getLength(instance); ++i) {
            BeanPropertyPath nextPath = path.isEmpty() ? new BeanPropertyPath(naming.describeType(Array.class)) : path;
            this.inspectObject(stack, nextPath.appendIndex(i), naming, Array.get(instance, i), visitor, stop);
        }
    }

    private void inspectIterable(List<Object> stack, BeanPropertyPath path, BeanNamingStrategy naming, Iterable<?> instance, BeanVisitor visitor, AtomicBoolean stop) {
        this.logInspection(path, "Iterable", instance);
        int seq = 0;
        for (Object object : instance) {
            BeanPropertyPath nextPath = path.isEmpty() ? new BeanPropertyPath(naming.describeType(Collection.class)) : path;
            this.inspectObject(stack, nextPath.appendIndex(seq++), naming, object, visitor, stop);
        }
    }

    private void logInspection(BeanPropertyPath path, String loggedType, Object instance) {
        LOG.trace("Inspect Path [{}]. {} [{}:{}]", new Object[]{path.fullPath(), loggedType, instance.getClass().getSimpleName(), System.identityHashCode(instance)});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Overflow {
        ALLOW_OVERFLOW,
        DENY_OVERFLOW;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InspectionDepth {
        BEAN,
        GRAPH;

    }
}

