/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.beans.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exparity.beans.core.BeanNamingStrategy;
import org.exparity.beans.core.ImmutableTypeProperty;
import org.exparity.beans.core.MethodWrapper;
import org.exparity.beans.core.TypeProperty;
import org.exparity.beans.core.TypeVisitor;
import org.exparity.beans.core.naming.CamelCaseNamingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInspector {
    private static final Logger LOG = LoggerFactory.getLogger(TypeInspector.class);
    private static final String SET_PREFIX = "set";
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";

    public void inspect(Class<?> type, TypeVisitor visitor) {
        this.inspect(type, new CamelCaseNamingStrategy(), visitor);
    }

    public void inspect(Class<?> type, BeanNamingStrategy naming, TypeVisitor visitor) {
        this.inspectType(type, naming, visitor);
    }

    public List<TypeProperty> propertyList(Class<?> type, BeanNamingStrategy naming) {
        Map<String, List<Method>> mutatorMap = this.createMutatorMap(type, naming);
        ArrayList<TypeProperty> properties = new ArrayList<TypeProperty>();
        for (Method accessor : type.getMethods()) {
            String propertyName;
            Method mutator;
            if (!TypeInspector.isAccessor(accessor) || (mutator = this.getMutatorFor(propertyName = this.toPropertyName(accessor, naming), accessor.getReturnType(), mutatorMap)) == null) continue;
            properties.add(new TypeProperty(propertyName, new MethodWrapper(accessor), new MethodWrapper(mutator)));
        }
        return properties;
    }

    public List<ImmutableTypeProperty> accessorList(Class<?> type, BeanNamingStrategy naming) {
        ArrayList<ImmutableTypeProperty> properties = new ArrayList<ImmutableTypeProperty>();
        for (Method accessor : type.getMethods()) {
            if (!TypeInspector.isAccessor(accessor)) continue;
            properties.add(new ImmutableTypeProperty(this.toPropertyName(accessor, naming), new MethodWrapper(accessor)));
        }
        return properties;
    }

    private void inspectType(Class<?> type, BeanNamingStrategy naming, TypeVisitor visitor) {
        this.logInspection(naming.describeRoot(type), "Object", type);
        for (TypeProperty property : this.propertyList(type, naming)) {
            visitor.visit(property);
        }
    }

    private void logInspection(String path, String loggedType, Object instance) {
        LOG.trace("Inspect Path [{}]. {} [{}:{}]", new Object[]{path, loggedType, instance.getClass().getSimpleName(), System.identityHashCode(instance)});
    }

    private Method getMutatorFor(String propertyName, Class<?> type, Map<String, List<Method>> mutatorMap) {
        List<Method> mutatorList = mutatorMap.get(propertyName);
        if (mutatorList != null) {
            for (Method mutator : mutatorList) {
                if (!mutator.getParameterTypes()[0].isAssignableFrom(type)) continue;
                return mutator;
            }
        }
        return null;
    }

    private Map<String, List<Method>> createMutatorMap(Class<?> type, BeanNamingStrategy naming) {
        HashMap<String, List<Method>> mutatorMap = new HashMap<String, List<Method>>();
        for (Method method : type.getMethods()) {
            if (!this.isSetter(method)) continue;
            String propertyName = this.toPropertyName(method, naming);
            ArrayList<Method> list = (ArrayList<Method>)mutatorMap.get(propertyName);
            if (list == null) {
                list = new ArrayList<Method>();
                list.add(method);
                mutatorMap.put(propertyName, list);
                continue;
            }
            list.add(method);
        }
        return mutatorMap;
    }

    private static boolean isAccessor(Method method) {
        if (method.getParameterTypes().length == 0) {
            return method.getName().startsWith(GET_PREFIX) || method.getName().startsWith(IS_PREFIX);
        }
        return false;
    }

    private boolean isSetter(Method method) {
        return method.getName().startsWith(SET_PREFIX) && method.getParameterTypes().length == 1;
    }

    private String toPropertyName(Method method, BeanNamingStrategy naming) {
        if (this.isSetter(method)) {
            return naming.describeProperty(method, SET_PREFIX);
        }
        if (TypeInspector.isAccessor(method)) {
            if (method.getName().startsWith(IS_PREFIX)) {
                return naming.describeProperty(method, IS_PREFIX);
            }
            if (method.getName().startsWith(GET_PREFIX)) {
                return naming.describeProperty(method, GET_PREFIX);
            }
            throw new RuntimeException("Getter which is not prefixed with is or get");
        }
        throw new IllegalArgumentException("Method does match the standards for bean properties");
    }
}

