/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.stub.core;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.math.RandomUtils;
import org.exparity.stub.core.ArrayFactory;
import org.exparity.stub.core.ValueFactory;
import org.exparity.stub.core.ValueFactoryException;
import org.exparity.stub.random.RandomBuilder;

public abstract class ValueFactories {
    public static <T> ValueFactory<T> theValue(final T value) {
        return new ValueFactory<T>(){

            @Override
            public T createValue() {
                return value;
            }
        };
    }

    public static ValueFactory<Object> aNullValue() {
        return new ValueFactory<Object>(){

            @Override
            public Object createValue() {
                return null;
            }
        };
    }

    public static ValueFactory<String> aRandomString() {
        return new ValueFactory<String>(){

            @Override
            public String createValue() {
                return RandomBuilder.aRandomString();
            }
        };
    }

    public static ValueFactory<Integer> aRandomInteger() {
        return new ValueFactory<Integer>(){

            @Override
            public Integer createValue() {
                return RandomBuilder.aRandomInteger();
            }
        };
    }

    public static ValueFactory<Short> aRandomShort() {
        return new ValueFactory<Short>(){

            @Override
            public Short createValue() {
                return RandomBuilder.aRandomShort();
            }
        };
    }

    public static ValueFactory<Long> aRandomLong() {
        return new ValueFactory<Long>(){

            @Override
            public Long createValue() {
                return RandomBuilder.aRandomLong();
            }
        };
    }

    public static ValueFactory<Double> aRandomDouble() {
        return new ValueFactory<Double>(){

            @Override
            public Double createValue() {
                return RandomBuilder.aRandomDouble();
            }
        };
    }

    public static ValueFactory<Float> aRandomFloat() {
        return new ValueFactory<Float>(){

            @Override
            public Float createValue() {
                return RandomBuilder.aRandomFloat();
            }
        };
    }

    public static ValueFactory<Boolean> aRandomBoolean() {
        return new ValueFactory<Boolean>(){

            @Override
            public Boolean createValue() {
                return RandomBuilder.aRandomBoolean();
            }
        };
    }

    public static ValueFactory<Date> aRandomDate() {
        return new ValueFactory<Date>(){

            @Override
            public Date createValue() {
                return RandomBuilder.aRandomDate();
            }
        };
    }

    public static ValueFactory<BigDecimal> aRandomDecimal() {
        return new ValueFactory<BigDecimal>(){

            @Override
            public BigDecimal createValue() {
                return RandomBuilder.aRandomDecimal();
            }
        };
    }

    public static ValueFactory<Byte> aRandomByte() {
        return new ValueFactory<Byte>(){

            @Override
            public Byte createValue() {
                return (byte)RandomUtils.nextInt((int)127);
            }
        };
    }

    public static ValueFactory<byte[]> aRandomByteArray() {
        return new ValueFactory<byte[]>(){

            @Override
            public byte[] createValue() {
                return RandomBuilder.aRandomByteArray();
            }
        };
    }

    public static ValueFactory<Character> aRandomChar() {
        return new ValueFactory<Character>(){

            @Override
            public Character createValue() {
                return RandomBuilder.aRandomChar();
            }
        };
    }

    public static <E> ValueFactory<E> aRandomEnum(final Class<E> enumType) {
        return new ValueFactory<E>(){

            @Override
            public E createValue() {
                T[] enumerationValues = enumType.getEnumConstants();
                if (enumerationValues.length == 0) {
                    throw new ValueFactoryException("Enumeration " + enumType.getName() + "has no values");
                }
                return enumerationValues[RandomUtils.nextInt((int)enumerationValues.length)];
            }
        };
    }

    public static <A> ArrayFactory<A> aRandomArrayOf(final ValueFactory<A> typeFactory) {
        return new ArrayFactory<A>(){

            @Override
            public A[] createValue(Class<A> type, int size) {
                Object array = Array.newInstance(type, size);
                for (int i = 0; i < size; ++i) {
                    Array.set(array, i, typeFactory.createValue());
                }
                return (Object[])array;
            }
        };
    }

    public static <T> ValueFactory<T> aNewInstanceOf(final Class<T> type) {
        return new ValueFactory<T>(){

            @Override
            public T createValue() {
                try {
                    return type.newInstance();
                }
                catch (Exception e) {
                    throw new ValueFactoryException("Failed to instantiate instance of '" + type.getCanonicalName() + "'", e);
                }
            }
        };
    }

    public static <T> ValueFactory<T> oneOf(ValueFactory<T> ... factories) {
        return ValueFactories.oneOf(Arrays.asList(factories));
    }

    public static <T> ValueFactory<T> oneOf(final Collection<ValueFactory<T>> factories) {
        return new ValueFactory<T>(){
            private final List<ValueFactory<T>> candidates;
            {
                this.candidates = new ArrayList(factories);
            }

            @Override
            public T createValue() {
                return this.candidates.get(RandomUtils.nextInt((int)this.candidates.size())).createValue();
            }
        };
    }

    public static <T> ValueFactory<T> oneOf(final T ... instances) {
        return new ValueFactory<T>(){

            @Override
            public T createValue() {
                return instances[RandomUtils.nextInt((int)instances.length)];
            }
        };
    }
}

