/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.stub.core;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.math.RandomUtils;
import org.exparity.stub.core.ArrayFactory;
import org.exparity.stub.core.ValueFactory;
import org.exparity.stub.core.ValueFactoryException;
import org.exparity.stub.random.RandomBuilder;

public abstract class ValueFactories {
    public static <T> ValueFactory<T> theValue(T value) {
        return () -> value;
    }

    public static ValueFactory<Object> aNullValue() {
        return () -> null;
    }

    public static ValueFactory<String> aRandomString() {
        return () -> RandomBuilder.aRandomString();
    }

    public static ValueFactory<Integer> aRandomInteger() {
        return () -> RandomBuilder.aRandomInteger();
    }

    public static ValueFactory<Short> aRandomShort() {
        return () -> RandomBuilder.aRandomShort();
    }

    public static ValueFactory<Long> aRandomLong() {
        return () -> RandomBuilder.aRandomLong();
    }

    public static ValueFactory<Double> aRandomDouble() {
        return () -> RandomBuilder.aRandomDouble();
    }

    public static ValueFactory<Float> aRandomFloat() {
        return () -> RandomBuilder.aRandomFloat();
    }

    public static ValueFactory<Boolean> aRandomBoolean() {
        return () -> RandomBuilder.aRandomBoolean();
    }

    public static ValueFactory<Date> aRandomDate() {
        return () -> RandomBuilder.aRandomDate();
    }

    public static ValueFactory<LocalDate> aRandomLocalDate() {
        return () -> RandomBuilder.aRandomLocalDate();
    }

    public static ValueFactory<LocalDateTime> aRandomLocalDateTime() {
        return () -> RandomBuilder.aRandomLocalDateTime();
    }

    public static ValueFactory<ZonedDateTime> aRandomZonedDateTime() {
        return () -> RandomBuilder.aRandomZonedDateTime();
    }

    public static ValueFactory<Instant> aRandomInstant() {
        return () -> RandomBuilder.aRandomInstant();
    }

    public static ValueFactory<BigDecimal> aRandomDecimal() {
        return () -> RandomBuilder.aRandomDecimal();
    }

    public static ValueFactory<Byte> aRandomByte() {
        return () -> RandomBuilder.aRandomByte();
    }

    public static ValueFactory<byte[]> aRandomByteArray() {
        return () -> RandomBuilder.aRandomByteArray();
    }

    public static ValueFactory<Character> aRandomChar() {
        return () -> RandomBuilder.aRandomChar();
    }

    public static <E> ValueFactory<E> aRandomEnum(Class<E> enumType) {
        return () -> {
            T[] enumerationValues = enumType.getEnumConstants();
            if (enumerationValues.length == 0) {
                throw new ValueFactoryException("Enumeration " + enumType.getName() + "has no values");
            }
            return enumerationValues[RandomUtils.nextInt((int)enumerationValues.length)];
        };
    }

    public static <A> ArrayFactory<A> aRandomArrayOf(ValueFactory<A> typeFactory) {
        return (type, size) -> {
            Object array = Array.newInstance(type, size);
            for (int i = 0; i < size; ++i) {
                Array.set(array, i, typeFactory.createValue());
            }
            return (Object[])array;
        };
    }

    public static <T> ValueFactory<T> aNewInstanceOf(Class<T> type) {
        return () -> {
            try {
                return type.newInstance();
            }
            catch (Exception e) {
                throw new ValueFactoryException("Failed to instantiate instance of '" + type.getCanonicalName() + "'", e);
            }
        };
    }

    public static <T> ValueFactory<T> oneOf(ValueFactory<T> ... factories) {
        return ValueFactories.oneOf(Arrays.asList(factories));
    }

    public static <T> ValueFactory<T> oneOf(Collection<ValueFactory<T>> factories) {
        return () -> ((ValueFactory)new ArrayList(factories).get(RandomUtils.nextInt((int)factories.size()))).createValue();
    }

    public static <T> ValueFactory<T> oneOf(List<ValueFactory<T>> factories) {
        return () -> ((ValueFactory)factories.get(RandomUtils.nextInt((int)factories.size()))).createValue();
    }

    public static <T> ValueFactory<T> oneOf(T ... instances) {
        return () -> instances[RandomUtils.nextInt((int)instances.length)];
    }
}

