/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.stub.stub;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.exparity.stub.core.ValueFactories;
import org.exparity.stub.core.ValueFactory;
import org.exparity.stub.stub.StubDefinition;
import org.exparity.stub.stub.StubFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Stub<T>
implements MethodInterceptor {
    private static final Map<Class<?>, ValueFactory> RANDOM_FACTORIES = new HashMap<Class<?>, ValueFactory>(){
        {
            this.put(Short.class, ValueFactories.aRandomShort());
            this.put(Short.TYPE, ValueFactories.aRandomShort());
            this.put(Integer.class, ValueFactories.aRandomInteger());
            this.put(Integer.TYPE, ValueFactories.aRandomInteger());
            this.put(Long.class, ValueFactories.aRandomLong());
            this.put(Long.TYPE, ValueFactories.aRandomLong());
            this.put(Double.class, ValueFactories.aRandomDouble());
            this.put(Double.TYPE, ValueFactories.aRandomDouble());
            this.put(Float.class, ValueFactories.aRandomFloat());
            this.put(Float.TYPE, ValueFactories.aRandomFloat());
            this.put(Boolean.class, ValueFactories.aRandomBoolean());
            this.put(Boolean.TYPE, ValueFactories.aRandomBoolean());
            this.put(Byte.class, ValueFactories.aRandomByte());
            this.put(Byte.TYPE, ValueFactories.aRandomByte());
            this.put(Character.class, ValueFactories.aRandomChar());
            this.put(Character.TYPE, ValueFactories.aRandomChar());
            this.put(String.class, ValueFactories.aRandomString());
            this.put(BigDecimal.class, ValueFactories.aRandomDecimal());
            this.put(Date.class, ValueFactories.aRandomDate());
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(Stub.class);
    private final StubDefinition definition;
    private final StubFactory factory;

    public Stub(StubDefinition definition, StubFactory factory) {
        this.definition = definition;
        this.factory = factory;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if (this.isProxiableMethod(method)) {
            LOG.info("Intercept [{}]", (Object)proxy.getSignature());
            return this.createValue(new StubDefinition(method.getGenericReturnType(), this.definition));
        }
        return proxy.invokeSuper(obj, args);
    }

    public Class<T> getRawType() {
        return this.definition.getActualType();
    }

    private <E> E createValue(StubDefinition definition) {
        Class<?> type = definition.getActualType();
        Optional<ValueFactory<?>> override = definition.getOverrideValueFactoryByType(type);
        if (override.isPresent()) {
            return (E)override.get().createValue();
        }
        if (type.isArray()) {
            return (E)this.createArray(type.getComponentType());
        }
        if (Map.class.isAssignableFrom(type)) {
            Type keyType = definition.getTypeByParameter("K");
            Type valueType = definition.getTypeByParameter("V");
            return (E)this.createMap(keyType, valueType, definition.aRandomCollectionSize());
        }
        if (Set.class.isAssignableFrom(type)) {
            Type elementType = definition.getTypeByParameter("E");
            return (E)this.createSet(elementType, definition.aRandomCollectionSize());
        }
        if (List.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type)) {
            Type elementType = definition.getTypeByParameter("E");
            return (E)this.createList(elementType, definition.aRandomCollectionSize());
        }
        ValueFactory factory = RANDOM_FACTORIES.get(type);
        if (factory != null) {
            return (E)factory.createValue();
        }
        if (type.isEnum()) {
            return (E)ValueFactories.aRandomEnum(type).createValue();
        }
        return (E)this.factory.createStub(definition);
    }

    private <E> Object createArray(Class<E> type) {
        Object array = Array.newInstance(type, this.definition.aRandomCollectionSize());
        for (int i = 0; i < Array.getLength(array); ++i) {
            Array.set(array, i, this.createValue(new StubDefinition(type, this.definition)));
        }
        return array;
    }

    private <E> Set<E> createSet(Type type, int length) {
        HashSet<E> set = new HashSet<E>();
        for (int i = 0; i < length; ++i) {
            E value = this.createValue(new StubDefinition(type, this.definition));
            if (value == null) continue;
            set.add(value);
        }
        return set;
    }

    private <E> List<E> createList(Type type, int length) {
        ArrayList<E> list = new ArrayList<E>();
        for (int i = 0; i < length; ++i) {
            E value = this.createValue(new StubDefinition(type, this.definition));
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    private <K, V> Map<K, V> createMap(Type keyType, Type valueType, int length) {
        HashMap map = new HashMap();
        for (int i = 0; i < length; ++i) {
            Object key = this.createValue(new StubDefinition(keyType, this.definition));
            if (key == null) continue;
            map.put(key, this.createValue(new StubDefinition(valueType, this.definition)));
        }
        return map;
    }

    private boolean isProxiableMethod(Method method) {
        switch (method.getName()) {
            case "equals": 
            case "iterator": 
            case "finalize": 
            case "hashCode": 
            case "toString": {
                return false;
            }
        }
        return method.getReturnType() != null;
    }

    public String toString() {
        return "Stub [" + this.definition.describe() + "]";
    }
}

