/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.stub.random;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.lang.time.DateUtils;
import org.exparity.stub.bean.BeanBuilder;
import org.exparity.stub.bean.BeanBuilderException;
import org.exparity.stub.core.ValueFactories;
import org.exparity.stub.core.ValueFactory;
import org.exparity.stub.core.ValueFactoryException;
import org.exparity.stub.random.RandomBuilderException;

public abstract class RandomBuilder {
    private static final Map<Class, ValueFactory> RANDOM_FACTORIES = new HashMap<Class, ValueFactory>(){
        {
            this.put(Short.class, ValueFactories.aRandomShort());
            this.put(Short.TYPE, ValueFactories.aRandomShort());
            this.put(Integer.class, ValueFactories.aRandomInteger());
            this.put(Integer.TYPE, ValueFactories.aRandomInteger());
            this.put(Long.class, ValueFactories.aRandomLong());
            this.put(Long.TYPE, ValueFactories.aRandomLong());
            this.put(Double.class, ValueFactories.aRandomDouble());
            this.put(Double.TYPE, ValueFactories.aRandomDouble());
            this.put(Float.class, ValueFactories.aRandomFloat());
            this.put(Float.TYPE, ValueFactories.aRandomFloat());
            this.put(Boolean.class, ValueFactories.aRandomBoolean());
            this.put(Boolean.TYPE, ValueFactories.aRandomBoolean());
            this.put(Byte.class, ValueFactories.aRandomByte());
            this.put(Byte.TYPE, ValueFactories.aRandomByte());
            this.put(Character.class, ValueFactories.aRandomChar());
            this.put(Character.TYPE, ValueFactories.aRandomChar());
            this.put(String.class, ValueFactories.aRandomString());
            this.put(BigDecimal.class, ValueFactories.aRandomDecimal());
            this.put(Date.class, ValueFactories.aRandomDate());
        }
    };
    private static final int DEFAULT_MAX_ARRAY_SIZE = 10;
    private static final int DEFAULT_MIN_ARRAY_SIZE = 2;
    private static final int MAX_STRING_LENGTH = 50;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int HOURS_PER_DAY = 24;
    private static final int DAYS_PER_YEAR = 365;
    private static final int SECONDS_IN_A_YEAR = 525600;
    private static final int SECONDS_IN_12_HOURS = 720;

    public static String aRandomString() {
        return RandomStringUtils.randomAlphanumeric((int)50);
    }

    public static String aRandomString(int length) {
        return RandomStringUtils.randomAlphanumeric((int)length);
    }

    public static Integer aRandomInteger() {
        return RandomUtils.nextInt();
    }

    public static Integer aRandomInteger(int min, int max) {
        if (min == max) {
            return min;
        }
        return min + Integer.valueOf(RandomUtils.nextInt((int)(max - min)));
    }

    public static Short aRandomShort() {
        return (short)RandomUtils.nextInt((int)Short.MAX_VALUE);
    }

    public static Short aRandomShort(short min, short max) {
        if (min == max) {
            return min;
        }
        return (short)(min + RandomUtils.nextInt((int)(max - min)));
    }

    public static Long aRandomLong() {
        return RandomUtils.nextLong();
    }

    public static Long aRandomLong(int min, int max) {
        if (min == max) {
            return min;
        }
        return min + RandomUtils.nextInt((int)(max - min));
    }

    public static Double aRandomDouble() {
        return RandomUtils.nextDouble();
    }

    public static Float aRandomFloat() {
        return Float.valueOf(RandomUtils.nextFloat());
    }

    public static <T> T oneOf(T ... rangeOfValues) {
        return rangeOfValues == null ? null : (T)rangeOfValues[RandomUtils.nextInt((int)rangeOfValues.length)];
    }

    public static Boolean aRandomBoolean() {
        return RandomUtils.nextBoolean();
    }

    public static Date aRandomDate() {
        return DateUtils.addSeconds((Date)new Date(), (int)RandomUtils.nextInt((int)525600));
    }

    public static LocalDate aRandomLocalDate() {
        return LocalDate.now().plus(RandomUtils.nextInt((int)365), ChronoUnit.DAYS);
    }

    public static LocalDateTime aRandomLocalDateTime() {
        return LocalDateTime.now().plus(RandomUtils.nextInt((int)525600), ChronoUnit.SECONDS);
    }

    public static LocalTime aRandomLocalTime() {
        return LocalTime.now().plusSeconds(RandomUtils.nextInt((int)720));
    }

    public static ZonedDateTime aRandomZonedDateTime() {
        return ZonedDateTime.now().plus(RandomUtils.nextInt((int)525600), ChronoUnit.SECONDS);
    }

    public static Instant aRandomInstant() {
        return Instant.now().plus((long)RandomUtils.nextInt((int)525600), ChronoUnit.SECONDS);
    }

    public static BigDecimal aRandomDecimal() {
        return BigDecimal.valueOf(RandomUtils.nextInt()).round(new MathContext(10, RoundingMode.HALF_UP)).movePointLeft(RandomUtils.nextInt((int)5));
    }

    public static Byte aRandomByte() {
        return (byte)RandomUtils.nextInt((int)127);
    }

    public static byte[] aRandomByteArray() {
        byte[] array = new byte[RandomBuilder.aRandomInteger(2, 1000).intValue()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = RandomBuilder.aRandomByte();
        }
        return array;
    }

    public static Character aRandomChar() {
        return Character.valueOf(RandomStringUtils.randomAlphabetic((int)1).charAt(0));
    }

    public static <E extends Enum<E>> E aRandomEnum(Class<E> enumType) {
        Enum[] enumerationValues = (Enum[])enumType.getEnumConstants();
        if (enumerationValues.length == 0) {
            throw new RandomBuilderException("Enumeration " + enumType.getName() + "has no values");
        }
        return (E)enumerationValues[RandomUtils.nextInt((int)enumerationValues.length)];
    }

    public static <E extends Enum<E>> E[] aRandomArrayOfEnum(Class<E> enumType) {
        return RandomBuilder.aRandomArrayOfEnum(enumType, (int)2, (int)10);
    }

    public static <E extends Enum<E>> E[] aRandomArrayOfEnum(Class<E> enumType, int min, int max) {
        return (Enum[])ValueFactories.aRandomArrayOf(ValueFactories.aRandomEnum(enumType)).createValue(enumType, RandomBuilder.aRandomInteger(min, max));
    }

    public static <T> T[] aRandomArrayOf(Class<T> type) {
        return RandomBuilder.aRandomArrayOf(type, 2, 10);
    }

    public static <T> T[] aRandomArrayOf(Class<T> type, int min, int max) {
        return ValueFactories.aRandomArrayOf(RandomBuilder.instanceFactoryFor(type, new RandomRestriction[0])).createValue(type, RandomBuilder.aRandomInteger(min, max));
    }

    public static <T> Collection<T> aRandomCollectionOf(Class<T> type) {
        return RandomBuilder.aRandomCollectionOf(type, 2, 10);
    }

    public static <T> Collection<T> aRandomCollectionOf(Class<T> type, int min, int max) {
        return RandomBuilder.aRandomListOf(type, min, max);
    }

    public static <T> List<T> aRandomListOf(Class<T> type) {
        return RandomBuilder.aRandomListOf(type, 2, 10);
    }

    public static <T> List<T> aRandomListOf(Class<T> type, int min, int max) {
        return Arrays.asList(RandomBuilder.aRandomArrayOf(type, min, max));
    }

    public static <T> T aRandomInstanceOf(Class<T> type) {
        return RandomBuilder.aRandomInstanceOf(type, new RandomRestriction[0]);
    }

    public static <T> T aRandomInstanceOf(Class<T> type, RandomRestriction ... restrictions) {
        try {
            return RandomBuilder.instanceFactoryFor(type, restrictions).createValue();
        }
        catch (BeanBuilderException e) {
            throw new RandomBuilderException("Failed to create a random instance of " + type.getName(), e);
        }
        catch (ValueFactoryException e) {
            throw new RandomBuilderException("Failed to create a random instance of " + type.getName(), e);
        }
    }

    public static <T> T aRandomInstanceOf(Class<T> type, List<RandomRestriction> restrictions) {
        return RandomBuilder.instanceFactoryFor(type, restrictions.toArray(new RandomRestriction[0])).createValue();
    }

    public static RandomRestriction property(String property, Object value) {
        return builder -> builder.property(property, value);
    }

    public static RandomRestriction property(String property, ValueFactory<?> factory) {
        return builder -> builder.property(property, factory);
    }

    public static <T> RandomRestriction factory(Class<T> type, ValueFactory<T> factory) {
        return builder -> builder.factory(type, factory);
    }

    public static RandomRestriction excludeProperty(String property) {
        return builder -> builder.excludeProperty(property);
    }

    public static RandomRestriction path(String path, Object value) {
        return builder -> builder.path(path, value);
    }

    public static RandomRestriction path(String path, ValueFactory<?> factory) {
        return builder -> builder.path(path, factory);
    }

    public static RandomRestriction excludePath(String path) {
        return builder -> builder.excludePath(path);
    }

    public static <P> RandomRestriction subtype(Class<P> superType, Class<? extends P> subType) {
        return builder -> builder.subtype(superType, subType);
    }

    public static <P> RandomRestriction subtype(Class<P> superType, Class<? extends P> ... subTypes) {
        return builder -> builder.subtype(superType, subTypes);
    }

    public static <P> RandomRestriction collectionSize(int size) {
        return builder -> builder.collectionSizeOf(size);
    }

    public static <P> RandomRestriction collectionSize(int min, int max) {
        return builder -> builder.collectionSizeRangeOf(min, max);
    }

    public static <P> RandomRestriction collectionSizeForPath(String path, int size) {
        return builder -> builder.collectionSizeForPathOf(path, size);
    }

    public static <P> RandomRestriction collectionSizeForPath(String path, int min, int max) {
        return builder -> builder.collectionSizeRangeForPathOf(path, min, max);
    }

    public static <P> RandomRestriction collectionSizeForProperty(String property, int size) {
        return builder -> builder.collectionSizeForPropertyOf(property, size);
    }

    public static <P> RandomRestriction collectionSizeForProperty(String property, int min, int max) {
        return builder -> builder.collectionSizeRangeForPropertyOf(property, min, max);
    }

    private static <T> ValueFactory<T> instanceFactoryFor(Class<T> type, RandomRestriction ... restrictions) {
        ValueFactory<T> factory = RANDOM_FACTORIES.get(type);
        if (factory == null) {
            BeanBuilder<T> builder = BeanBuilder.aRandomInstanceOf(type);
            for (RandomRestriction restriction : restrictions) {
                restriction.applyTo(builder);
            }
            factory = ValueFactories.theValue(builder.build());
        }
        return factory;
    }

    @FunctionalInterface
    public static interface RandomRestriction {
        public void applyTo(BeanBuilder<?> var1);
    }
}

