/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.stub.stub;

import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import org.exparity.stub.stub.Stub;
import org.exparity.stub.stub.StubDefinition;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StubFactory {
    private static final Logger LOG = LoggerFactory.getLogger(StubFactory.class);

    StubFactory() {
    }

    public <T> T createStub(StubDefinition<T> definition) {
        if (definition.isFinal()) {
            throw new IllegalArgumentException("Final classes cannot be prototyped");
        }
        T proxy = this.createProxy(new Stub<T>(definition, this));
        LOG.info("Proxied {} using [{}]", (Object)definition.describe(), proxy);
        return proxy;
    }

    private <T> T createProxy(Stub<T> stub) {
        return this.createProxy(stub.getRawType(), stub);
    }

    public <T> T createProxy(Class<T> rawType, MethodInterceptor callback) {
        return this.createProxyInstance(this.createProxyType(rawType, callback));
    }

    private <T> T createProxyInstance(Class<T> proxyType) {
        ObjenesisStd instantiatorFactory = new ObjenesisStd();
        ObjectInstantiator instanceFactory = instantiatorFactory.getInstantiatorOf(proxyType);
        Object instance = instanceFactory.newInstance();
        LOG.debug("Produce Proxy Instance [{}] for [{}]", (Object)System.identityHashCode(instance), (Object)proxyType.getName());
        return (T)instance;
    }

    private <T> Class<T> createProxyType(Class<T> rawType, MethodInterceptor callback) {
        Enhancer classFactory = new Enhancer();
        if (rawType.isInterface()) {
            classFactory.setInterfaces(new Class[]{rawType});
        } else {
            classFactory.setSuperclass(rawType);
        }
        classFactory.setCallbackType(callback.getClass());
        Class proxyType = classFactory.createClass();
        Enhancer.registerCallbacks((Class)proxyType, (Callback[])new Callback[]{callback});
        return proxyType;
    }
}

