/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.stub.stub;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.exparity.stub.core.ValueFactories;
import org.exparity.stub.core.ValueFactory;
import org.exparity.stub.stub.StubDefinition;
import org.exparity.stub.stub.StubFactory;
import org.exparity.stub.stub.TypeReference;

public class StubBuilder<T> {
    private final StubDefinition<T> definition;
    private final StubFactory factory = new StubFactory();

    public static <T> StubBuilder<T> aRandomStubOf(Class<T> type) {
        if (StubBuilder.isGenericType(type)) {
            throw new IllegalArgumentException("Use StubBuilder.aRandomStubOf(final TypeReference<T> typeRef) method to create prototypes for generic types. See javadocs on method for example.");
        }
        return new StubBuilder<T>(type);
    }

    public static <T> StubBuilder<T> aRandomStubOf(TypeReference<T> type) {
        return new StubBuilder<T>(type.getType());
    }

    private StubBuilder(Type type) {
        this.definition = new StubDefinition(type);
    }

    private StubBuilder(Class<T> type) {
        this.definition = new StubDefinition(type);
    }

    public <V> StubBuilder<T> with(Class<V> type, ValueFactory<V> factory) {
        this.definition.addOverride(type, factory);
        return this;
    }

    public <X> StubBuilder<T> factory(Class<X> type, ValueFactory<X> factory) {
        this.definition.addOverride(type, factory);
        return this;
    }

    public StubBuilder<T> collectionSizeOf(int size) {
        return this.collectionSizeRangeOf(size, size);
    }

    public StubBuilder<T> collectionSizeRangeOf(int min, int max) {
        this.definition.setCollectionSizeRange(min, max);
        return this;
    }

    public <X> StubBuilder<T> subtype(Class<X> supertype, Class<? extends X> subtype) {
        return this.with(supertype, ValueFactories.oneOf(this.createInstanceOfFactoriesForTypes(subtype)));
    }

    public <X> StubBuilder<T> subtype(Class<X> supertype, Class<? extends X> ... subtypes) {
        return this.with(supertype, ValueFactories.oneOf(this.createInstanceOfFactoriesForTypes(subtypes)));
    }

    public T build() {
        return this.factory.createStub(this.definition);
    }

    private <X> List<ValueFactory<X>> createInstanceOfFactoriesForTypes(Class<? extends X> ... subtypes) {
        ArrayList<ValueFactory<X>> factories = new ArrayList<ValueFactory<X>>();
        for (Class<? extends X> subtype : subtypes) {
            factories.add(ValueFactories.aNewInstanceOf(subtype));
        }
        return factories;
    }

    private static boolean isGenericType(Class<?> type) {
        return type.getTypeParameters() != null && type.getTypeParameters().length > 0;
    }
}

