/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.stub.stub;

import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.exparity.stub.core.ValueFactory;
import org.exparity.stub.random.RandomBuilder;

class StubDefinition<T> {
    private final Map<String, Type> typeParameters = new HashMap<String, Type>();
    private final Type type;
    private final Map<Class<?>, ValueFactory<?>> overrides = new HashMap();
    private int collectionSizeMin = 1;
    private int collectionSizeMax = 5;

    public StubDefinition(Type type, StubDefinition<?> parent) {
        this.type = type;
        this.typeParameters.putAll(parent.typeParameters);
        this.typeParameters.putAll(StubDefinition.getTypeArguments(type));
        this.overrides.putAll(parent.overrides);
        this.collectionSizeMin = parent.collectionSizeMin;
        this.collectionSizeMax = parent.collectionSizeMax;
    }

    public StubDefinition(Type type) {
        this(type, StubDefinition.getTypeArguments(type));
    }

    public StubDefinition(Class<?> type) {
        this(type, StubDefinition.getTypeArguments(type));
    }

    private StubDefinition(Type type, Map<String, Type> typeParameters) {
        this.typeParameters.putAll(typeParameters);
        this.type = type;
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getActualType().getModifiers());
    }

    public Class<T> getActualType() {
        return this.getActualType(this.type);
    }

    public Type getRawType() {
        return this.type;
    }

    public void setCollectionSizeRange(int min, int max) {
        this.collectionSizeMin = min;
        this.collectionSizeMax = max;
    }

    public <O> void addOverride(Class<O> type, ValueFactory<O> factory) {
        this.overrides.put(type, factory);
    }

    public Class<T> getActualType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof TypeVariable) {
            return this.getActualType(this.getTypeByParameter(((TypeVariable)type).getName()));
        }
        throw new RuntimeException("Failed to get actual type for '" + type + "'");
    }

    public Type getTypeByParameter(String typeVariable) {
        Type type = this.typeParameters.get(typeVariable);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Unknown type variable '" + typeVariable + "' in '" + this.type + "'");
    }

    private static Map<String, Type> getTypeArguments(Type type) {
        if (type instanceof ParameterizedType) {
            return StubDefinition.getTypeArguments((ParameterizedType)type);
        }
        return new HashMap<String, Type>();
    }

    private static Map<String, Type> getTypeArguments(ParameterizedType genericType) {
        ParameterizedType type = genericType;
        Type[] typeArguments = type.getActualTypeArguments();
        TypeVariable<Class<T>>[] typeKeys = ((Class)type.getRawType()).getTypeParameters();
        HashMap<String, Type> parameterizedTypes = new HashMap<String, Type>();
        for (int i = 0; i < typeKeys.length; ++i) {
            parameterizedTypes.put(typeKeys[i].getName(), typeArguments[i]);
        }
        return parameterizedTypes;
    }

    public String describe() {
        return this.getActualType().getName();
    }

    public int aRandomCollectionSize() {
        return this.collectionSizeMin == this.collectionSizeMax ? this.collectionSizeMin : RandomBuilder.aRandomInteger(this.collectionSizeMin, this.collectionSizeMax);
    }

    public Optional<ValueFactory<?>> getOverrideValueFactoryByType(Class<?> type) {
        for (Map.Entry<Class<?>, ValueFactory<?>> keyedFactory : this.overrides.entrySet()) {
            if (!type.isAssignableFrom(keyedFactory.getKey())) continue;
            return Optional.of(keyedFactory.getValue());
        }
        return Optional.empty();
    }
}

