/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.stub.random;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.lang.time.DateUtils;
import org.exparity.stub.bean.BeanBuilder;
import org.exparity.stub.bean.BeanBuilderException;
import org.exparity.stub.core.ValueFactories;
import org.exparity.stub.core.ValueFactory;
import org.exparity.stub.core.ValueFactoryException;
import org.exparity.stub.random.RandomBuilderException;
import org.exparity.stub.stub.StubBuilder;
import org.exparity.stub.stub.TypeReference;

public abstract class RandomBuilder {
    private static final Map<Class, ValueFactory> RANDOM_FACTORIES = new HashMap<Class, ValueFactory>(){
        {
            this.put(Short.class, ValueFactories.aRandomShort());
            this.put(Short.TYPE, ValueFactories.aRandomShort());
            this.put(Integer.class, ValueFactories.aRandomInteger());
            this.put(Integer.TYPE, ValueFactories.aRandomInteger());
            this.put(Long.class, ValueFactories.aRandomLong());
            this.put(Long.TYPE, ValueFactories.aRandomLong());
            this.put(Double.class, ValueFactories.aRandomDouble());
            this.put(Double.TYPE, ValueFactories.aRandomDouble());
            this.put(Float.class, ValueFactories.aRandomFloat());
            this.put(Float.TYPE, ValueFactories.aRandomFloat());
            this.put(Boolean.class, ValueFactories.aRandomBoolean());
            this.put(Boolean.TYPE, ValueFactories.aRandomBoolean());
            this.put(Byte.class, ValueFactories.aRandomByte());
            this.put(Byte.TYPE, ValueFactories.aRandomByte());
            this.put(Character.class, ValueFactories.aRandomChar());
            this.put(Character.TYPE, ValueFactories.aRandomChar());
            this.put(String.class, ValueFactories.aRandomString());
            this.put(BigDecimal.class, ValueFactories.aRandomDecimal());
            this.put(Date.class, ValueFactories.aRandomDate());
            this.put(Date.class, ValueFactories.aRandomDate());
            this.put(LocalDate.class, ValueFactories.aRandomLocalDate());
            this.put(LocalTime.class, ValueFactories.aRandomLocalTime());
            this.put(LocalDateTime.class, ValueFactories.aRandomLocalDateTime());
            this.put(ZonedDateTime.class, ValueFactories.aRandomZonedDateTime());
            this.put(Duration.class, ValueFactories.aRandomDuration());
            this.put(Instant.class, ValueFactories.aRandomInstant());
        }
    };
    private static final int DEFAULT_MAX_ARRAY_SIZE = 10;
    private static final int DEFAULT_MIN_ARRAY_SIZE = 2;
    private static final int MAX_STRING_LENGTH = 10;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int HOURS_PER_DAY = 24;
    private static final int DAYS_PER_YEAR = 365;
    private static final int SECONDS_IN_A_YEAR = 525600;
    private static final int SECONDS_IN_12_HOURS = 720;

    public static String aRandomString() {
        return RandomStringUtils.randomAlphanumeric((int)10);
    }

    public static String aRandomString(int length) {
        return RandomStringUtils.randomAlphanumeric((int)length);
    }

    public static String aRandomAscii() {
        return RandomBuilder.aRandomAscii(10);
    }

    public static String aRandomAscii(int length) {
        return RandomStringUtils.randomAscii((int)length);
    }

    public static String aRandomAlphabetic() {
        return RandomBuilder.aRandomAlphabetic(10);
    }

    public static String aRandomAlphabetic(int length) {
        return RandomStringUtils.randomAlphabetic((int)length);
    }

    public static String aRandomNumeric() {
        return RandomBuilder.aRandomNumeric(10);
    }

    public static String aRandomNumeric(int length) {
        return RandomStringUtils.randomNumeric((int)length);
    }

    public static Integer aRandomInteger() {
        return RandomUtils.nextInt();
    }

    public static Integer aRandomInteger(int min, int max) {
        if (min == max) {
            return min;
        }
        return min + Integer.valueOf(RandomUtils.nextInt((int)(max - min)));
    }

    public static Short aRandomShort() {
        return (short)RandomUtils.nextInt((int)Short.MAX_VALUE);
    }

    public static Short aRandomShort(short min, short max) {
        if (min == max) {
            return min;
        }
        return (short)(min + RandomUtils.nextInt((int)(max - min)));
    }

    public static Long aRandomLong() {
        return RandomUtils.nextLong();
    }

    public static Long aRandomLong(int min, int max) {
        if (min == max) {
            return min;
        }
        return min + RandomUtils.nextInt((int)(max - min));
    }

    public static Double aRandomDouble() {
        return RandomUtils.nextDouble();
    }

    public static Float aRandomFloat() {
        return Float.valueOf(RandomUtils.nextFloat());
    }

    public static <T> T oneOf(T ... rangeOfValues) {
        return rangeOfValues == null ? null : (T)rangeOfValues[RandomUtils.nextInt((int)rangeOfValues.length)];
    }

    public static Boolean aRandomBoolean() {
        return RandomUtils.nextBoolean();
    }

    public static Date aRandomDate() {
        return DateUtils.addSeconds((Date)new Date(), (int)RandomUtils.nextInt((int)525600));
    }

    public static LocalDate aRandomLocalDate() {
        return LocalDate.now().plus(RandomUtils.nextInt((int)365), ChronoUnit.DAYS);
    }

    public static Duration aRandomDuration() {
        return Duration.of(RandomBuilder.aRandomInteger(1, 60).intValue(), ChronoUnit.SECONDS);
    }

    public static LocalDateTime aRandomLocalDateTime() {
        return LocalDateTime.now().plus(RandomUtils.nextInt((int)525600), ChronoUnit.SECONDS);
    }

    public static LocalTime aRandomLocalTime() {
        return LocalTime.now().plusSeconds(RandomUtils.nextInt((int)720));
    }

    public static ZonedDateTime aRandomZonedDateTime() {
        return ZonedDateTime.now().plus(RandomUtils.nextInt((int)525600), ChronoUnit.SECONDS);
    }

    public static Instant aRandomInstant() {
        return Instant.now().plus((long)RandomUtils.nextInt((int)525600), ChronoUnit.SECONDS);
    }

    public static BigDecimal aRandomDecimal() {
        return BigDecimal.valueOf(RandomUtils.nextInt()).round(new MathContext(10, RoundingMode.HALF_UP)).movePointLeft(RandomUtils.nextInt((int)5));
    }

    public static Byte aRandomByte() {
        return (byte)RandomUtils.nextInt((int)127);
    }

    public static byte[] aRandomByteArray() {
        byte[] array = new byte[RandomBuilder.aRandomInteger(2, 1000).intValue()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = RandomBuilder.aRandomByte();
        }
        return array;
    }

    public static Character aRandomChar() {
        return Character.valueOf(RandomStringUtils.randomAlphabetic((int)1).charAt(0));
    }

    public static <E extends Enum<E>> E aRandomEnum(Class<E> enumType) {
        Enum[] enumerationValues = (Enum[])enumType.getEnumConstants();
        if (enumerationValues.length == 0) {
            throw new RandomBuilderException("Enumeration " + enumType.getName() + "has no values");
        }
        return (E)enumerationValues[RandomUtils.nextInt((int)enumerationValues.length)];
    }

    public static <E extends Enum<E>> E[] aRandomArrayOfEnum(Class<E> enumType) {
        return RandomBuilder.aRandomArrayOfEnum(enumType, (int)2, (int)10);
    }

    public static <E extends Enum<E>> E[] aRandomArrayOfEnum(Class<E> enumType, int min, int max) {
        return (Enum[])ValueFactories.aRandomArrayOf(ValueFactories.aRandomEnum(enumType), RandomBuilder.aRandomInteger(min, max)).createValue();
    }

    public static <T> T[] aRandomArrayOf(Class<T> type) {
        return RandomBuilder.aRandomArrayOf(type, 2, 10);
    }

    public static <T> T[] aRandomArrayOf(Class<T> type, int min, int max) {
        return ValueFactories.aRandomArrayOf(RandomBuilder.instanceFactoryFor(type, new RandomRestriction[0]), RandomBuilder.aRandomInteger(min, max)).createValue();
    }

    public static <T> Collection<T> aRandomCollectionOf(Class<T> type) {
        return RandomBuilder.aRandomCollectionOf(type, 2, 10);
    }

    public static <T> Collection<T> aRandomCollectionOf(Class<T> type, int min, int max) {
        return RandomBuilder.aRandomListOf(type, min, max);
    }

    public static <T> List<T> aRandomListOf(Class<T> type) {
        return RandomBuilder.aRandomListOf(type, 2, 10);
    }

    public static <T> List<T> aRandomListOf(Class<T> type, int min, int max) {
        return Arrays.asList(RandomBuilder.aRandomArrayOf(type, min, max));
    }

    public static <T> T aRandomStubOf(Class<T> type) {
        return StubBuilder.aRandomStubOf(type).build();
    }

    public static <T> T aRandomStubOf(TypeReference<T> type) {
        return StubBuilder.aRandomStubOf(type).build();
    }

    public static <T> T aRandomInstanceOf(Class<T> type) {
        return RandomBuilder.aRandomInstanceOf(type, new RandomRestriction[0]);
    }

    public static <T> T aRandomInstanceOf(Class<T> type, RandomRestriction ... restrictions) {
        try {
            return RandomBuilder.instanceFactoryFor(type, restrictions).createValue();
        }
        catch (BeanBuilderException e) {
            throw new RandomBuilderException("Failed to create a random instance of " + type.getName(), e);
        }
        catch (ValueFactoryException e) {
            throw new RandomBuilderException("Failed to create a random instance of " + type.getName(), e);
        }
    }

    public static <T> T aRandomInstanceOf(Class<T> type, List<RandomRestriction> restrictions) {
        return RandomBuilder.instanceFactoryFor(type, restrictions.toArray(new RandomRestriction[0])).createValue();
    }

    public static RandomRestriction property(String property, Object value) {
        return builder -> builder.property(property, value);
    }

    public static RandomRestriction property(String property, ValueFactory<?> factory) {
        return builder -> builder.property(property, factory);
    }

    public static <T> RandomRestriction factory(Class<T> type, ValueFactory<T> factory) {
        return builder -> builder.factory(type, factory);
    }

    public static RandomRestriction excludeProperty(String property) {
        return builder -> builder.excludeProperty(property);
    }

    public static RandomRestriction path(String path, Object value) {
        return builder -> builder.path(path, value);
    }

    public static RandomRestriction path(String path, ValueFactory<?> factory) {
        return builder -> builder.path(path, factory);
    }

    public static RandomRestriction excludePath(String path) {
        return builder -> builder.excludePath(path);
    }

    public static <P> RandomRestriction subtype(Class<P> superType, Class<? extends P> subType) {
        return builder -> builder.subtype(superType, subType);
    }

    public static <P> RandomRestriction subtype(Class<P> superType, Class<? extends P> ... subTypes) {
        return builder -> builder.subtype(superType, subTypes);
    }

    public static <P> RandomRestriction collectionSize(int size) {
        return builder -> builder.collectionSizeOf(size);
    }

    public static <P> RandomRestriction collectionSize(int min, int max) {
        return builder -> builder.collectionSizeRangeOf(min, max);
    }

    public static <P> RandomRestriction collectionSizeForPath(String path, int size) {
        return builder -> builder.collectionSizeForPathOf(path, size);
    }

    public static <P> RandomRestriction collectionSizeForPath(String path, int min, int max) {
        return builder -> builder.collectionSizeRangeForPathOf(path, min, max);
    }

    public static <P> RandomRestriction collectionSizeForProperty(String property, int size) {
        return builder -> builder.collectionSizeForPropertyOf(property, size);
    }

    public static <P> RandomRestriction collectionSizeForProperty(String property, int min, int max) {
        return builder -> builder.collectionSizeRangeForPropertyOf(property, min, max);
    }

    private static <T> ValueFactory<T> instanceFactoryFor(Class<T> type, RandomRestriction ... restrictions) {
        ValueFactory factory = RANDOM_FACTORIES.get(type);
        if (factory != null) {
            return factory;
        }
        if (type.isEnum()) {
            return ValueFactories.aRandomEnum(type);
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            ValueFactory<?> componentTypeValueFactory = RandomBuilder.instanceFactoryFor(componentType, restrictions);
            return ValueFactories.aRandomArrayOf(componentTypeValueFactory, 1);
        }
        if (type.isInterface() || Modifier.isAbstract(type.getModifiers())) {
            return ValueFactories.theValue(RandomBuilder.aRandomStubOf(type));
        }
        if (RandomBuilder.isBean(type)) {
            BeanBuilder<T> builder = BeanBuilder.aRandomInstanceOf(type);
            for (RandomRestriction restriction : restrictions) {
                restriction.applyTo(builder);
            }
            return ValueFactories.theValue(builder.build());
        }
        Optional<Constructor<T>> constructor = RandomBuilder.findConstructor(type);
        if (constructor.isPresent()) {
            return ValueFactories.theValue(RandomBuilder.createInstance(constructor.get()));
        }
        return ValueFactories.theValue(ValueFactories.anEmptyInstanceOf(type).createValue());
    }

    private static boolean isBean(Class<?> type) {
        return RandomBuilder.hasDefaultConstructor(type);
    }

    private static boolean hasDefaultConstructor(Class<?> type) {
        return Stream.of(type.getConstructors()).map(Constructor::getParameterCount).anyMatch(count -> count == 0);
    }

    private static <T> Optional<Constructor<T>> findConstructor(Class<T> type) {
        return Stream.of(type.getConstructors()).min(Comparator.comparing(Constructor::getParameterCount));
    }

    private static <T> T createInstance(Constructor<T> constructor) {
        try {
            Type[] params = constructor.getGenericParameterTypes();
            Object[] initargs = RandomBuilder.createArguments(params);
            return constructor.newInstance(initargs);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new RandomBuilderException("Could not instantiate type " + constructor.getDeclaringClass().getName() + " using " + constructor, e);
        }
    }

    private static Object[] createArguments(Type[] types) {
        if (types.length == 0) {
            return new Object[0];
        }
        Object[] args = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            Class<? extends Object> rawType = RandomBuilder.getRawType(types[i]);
            org.exparity.beans.Type type = org.exparity.beans.Type.type(rawType);
            if (type.isArray()) {
                Object value;
                Class<?> arrayType = rawType.getComponentType();
                args[i] = value = Array.newInstance(arrayType, 0);
                continue;
            }
            args[i] = type.is(Map.class) ? Collections.singletonMap(RandomBuilder.getActualType(types[i], 0), RandomBuilder.getActualType(types[i], 1)) : (type.is(Set.class) ? Collections.singleton(RandomBuilder.aRandomInstanceOf(RandomBuilder.getActualType(types[i], 0))) : (type.is(List.class) || type.is(Collection.class) ? Collections.singletonList(RandomBuilder.aRandomInstanceOf(RandomBuilder.getActualType(types[i], 0))) : RandomBuilder.aRandomInstanceOf(rawType)));
        }
        return args;
    }

    private static Class<? extends Object> getActualType(Type type, int typeOrdinal) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return RandomBuilder.getActualType(((ParameterizedType)type).getActualTypeArguments()[typeOrdinal], 0);
        }
        throw new IllegalArgumentException("Unknown type subclass '" + type.getClass());
    }

    private static Class<? extends Object> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return RandomBuilder.getRawType(((ParameterizedType)type).getRawType());
        }
        throw new IllegalArgumentException("Unknown type subclass '" + type.getClass());
    }

    @FunctionalInterface
    public static interface RandomRestriction {
        public void applyTo(BeanBuilder<?> var1);
    }
}

