/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import net.sf.cglib.proxy.MethodProxy;
import org.exparity.expectamundo.core.Prototype;
import org.exparity.expectamundo.core.PrototypeFactory;
import org.exparity.expectamundo.core.PrototypeInterceptor;
import org.exparity.expectamundo.core.PrototypeProperty;
import org.exparity.expectamundo.core.Prototyped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrototypeBeanInterceptor
implements PrototypeInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(PrototypeBeanInterceptor.class);
    private final PrototypeFactory factory;

    public PrototypeBeanInterceptor(PrototypeFactory factory) {
        this.factory = factory;
    }

    @Override
    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy, Prototype<?> currentPrototype) throws Throwable {
        PrototypeProperty activeProperty = new PrototypeProperty(currentPrototype.getParentProperty(), method, proxy, args);
        currentPrototype.setActiveProperty(activeProperty);
        if (this.isProxiableMethod(method)) {
            Class<?> returnType = this.getClassForPrototype(activeProperty, currentPrototype);
            if (returnType.isPrimitive() || Modifier.isFinal(returnType.getModifiers())) {
                return null;
            }
            Object child = this.factory.createPrototype(activeProperty, currentPrototype);
            currentPrototype.addChild((Prototyped)child);
            return child;
        }
        LOG.debug("Discard Method [{}]", (Object)method);
        return proxy.invokeSuper(obj, args);
    }

    private boolean isProxiableMethod(Method method) {
        switch (method.getName()) {
            case "iterator": 
            case "finalize": 
            case "hashCode": 
            case "toString": {
                return false;
            }
        }
        return method.getReturnType() != null;
    }

    private Class<?> getClassForPrototype(PrototypeProperty activeProperty, Prototype<?> currentPrototype) {
        Type genericType = activeProperty.getGenericReturnType();
        if (genericType instanceof Class) {
            return (Class)genericType;
        }
        if (genericType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)genericType).getRawType();
        }
        if (genericType instanceof TypeVariable) {
            return currentPrototype.getTypeParameters().get(((TypeVariable)genericType).getName());
        }
        throw new RuntimeException("Failed to get prototype class for '" + genericType + "'");
    }
}

