/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.proxy.MethodProxy;

public class PrototypeProperty {
    private final Method method;
    private final MethodProxy proxy;
    private final Object[] args;
    private PrototypeProperty parent;

    public PrototypeProperty(PrototypeProperty parent, Method method, MethodProxy proxy, Object[] args) {
        this.parent = parent;
        this.method = method;
        this.args = args;
        this.proxy = proxy;
    }

    public PrototypeProperty(Method method, MethodProxy proxy, Object[] args) {
        this.method = method;
        this.args = args;
        this.proxy = proxy;
    }

    public Object getPropertyValue(Object actual) {
        try {
            return this.proxy.invoke(this.parent != null ? this.parent.getPropertyValue(actual) : actual, this.args);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public String getPath() {
        return this.parent != null ? this.parent.getPath() + "." + this.stripPrefix(this.method.getName()) : this.stripPrefix(this.method.getName());
    }

    private String stripPrefix(String name) {
        return this.args.length == 0 ? name + "()" : name + "(...)";
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public Type getGenericReturnType() {
        return this.method.getGenericReturnType();
    }

    public boolean isGeneric() {
        return !(this.method.getGenericReturnType() instanceof Class);
    }

    public Map<String, Class<?>> getGenericTypeArguments() {
        HashMap parameterizedTypes = new HashMap();
        if (this.method.getGenericReturnType() instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)this.method.getGenericReturnType()).getActualTypeArguments();
            TypeVariable<Class<T>>[] typeKeys = ((Class)((ParameterizedType)this.method.getGenericReturnType()).getRawType()).getTypeParameters();
            for (int i = 0; i < typeKeys.length; ++i) {
                parameterizedTypes.put(typeKeys[i].getName(), (Class)typeArguments[i]);
            }
            return parameterizedTypes;
        }
        return parameterizedTypes;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.method.getDeclaringClass().getSimpleName() + ":" + this.proxy.getSignature().getName() + "]";
    }
}

