/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core;

import java.util.List;
import org.exparity.expectamundo.core.PrototypePropertyMatcher;
import org.exparity.expectamundo.core.Prototyped;

public class PrototypeVerifier<T> {
    private final T actual;

    public PrototypeVerifier(T actual) {
        this.actual = actual;
    }

    public void matches(T expected) {
        if (!Prototyped.class.isInstance(expected)) {
            throw new IllegalArgumentException("Object does not implement ExceptionList. Please construct using PrototypeMatcher.expected");
        }
        StringBuffer mismatchDescription = new StringBuffer();
        mismatchDescription.append("a ").append(this.actual.getClass().getSimpleName()).append(" containing properties :\n");
        boolean matches = true;
        Prototyped prototype = (Prototyped)expected;
        List<PrototypePropertyMatcher> expectations = prototype.getExpectations();
        for (PrototypePropertyMatcher expectation : expectations) {
            Object actualValue;
            if (expectation.matches(actualValue = expectation.getPropertyValue(this.actual))) continue;
            mismatchDescription.append("\t").append(expectation.getPropertyPath()).append(" is ").append(actualValue);
            matches = false;
        }
        if (!matches) {
            StringBuffer buffer = new StringBuffer("\nExpected ");
            this.describeTo(buffer, prototype.getRawType(), expectations);
            buffer.append("\nbut actual is ").append(mismatchDescription);
            throw new AssertionError((Object)buffer.toString());
        }
    }

    private void describeTo(StringBuffer description, Class<?> rawType, List<PrototypePropertyMatcher> expectations) {
        description.append("a ").append(rawType.getSimpleName());
        if (!expectations.isEmpty()) {
            description.append(" containing properties :");
            for (PrototypePropertyMatcher expecation : expectations) {
                description.append("\n\t").append(expecation.getPropertyPath()).append(" is ").append(expecation.getExpectation());
            }
        }
    }
}

