/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.hamcrest;

import java.util.List;
import org.exparity.expectamundo.core.PrototypePropertyMatcher;
import org.exparity.expectamundo.core.Prototyped;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class PrototypeMatcher<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final Prototyped<T> expected;

    public PrototypeMatcher(Prototyped<T> stub) {
        this.expected = stub;
    }

    public void describeTo(Description description) {
        this.describeTo(description, this.expected.getRawType(), this.expected.getExpectations());
    }

    private void describeTo(Description description, Class<?> rawType, List<PrototypePropertyMatcher> expectations) {
        description.appendText("a ").appendText(rawType.getSimpleName());
        if (!expectations.isEmpty()) {
            description.appendText(" containing properties :");
            for (PrototypePropertyMatcher expecation : expectations) {
                description.appendText("\n\t").appendText(expecation.getPropertyPath()).appendText(" ").appendText(expecation.getExpectation());
            }
        }
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        mismatchDescription.appendText("a ").appendText(actual.getClass().getSimpleName()).appendText(" containing properties :\n");
        boolean matches = true;
        for (PrototypePropertyMatcher expectation : this.expected.getExpectations()) {
            Object actualValue;
            if (expectation.matches(actualValue = expectation.getPropertyValue(actual))) continue;
            mismatchDescription.appendText("\t").appendText(expectation.getPropertyPath()).appendText(" ").appendValue(actualValue);
            matches = false;
        }
        return matches;
    }
}

