/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core;

import java.util.List;
import org.exparity.expectamundo.core.PrototypeMatchResult;
import org.exparity.expectamundo.core.PrototypePropertyMatcher;
import org.exparity.expectamundo.core.Prototyped;

public class PrototypeListMatchResult<T> {
    private final T expectation;
    private final Prototyped<T> prototyped;
    private List<PrototypeMatchResult<T>> mismatches;

    public PrototypeListMatchResult(T expectation, List<PrototypeMatchResult<T>> mismatches) {
        this.expectation = expectation;
        if (!Prototyped.class.isInstance(expectation)) {
            throw new IllegalArgumentException("Object does not implement Prototyped. Please construct using Expectamundo.prototype");
        }
        this.prototyped = (Prototyped)expectation;
        this.mismatches = mismatches;
    }

    public boolean isMismatch() {
        return !this.mismatches.isEmpty();
    }

    public List<PrototypeMatchResult<T>> getMismatches() {
        return this.mismatches;
    }

    public T getExpectation() {
        return this.expectation;
    }

    public Prototyped<T> getExpectationAsPrototype() {
        return this.prototyped;
    }

    public List<PrototypePropertyMatcher> getExpectations() {
        return this.prototyped.getExpectations();
    }
}

