/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core;

import java.util.Arrays;
import java.util.Collection;
import org.exparity.expectamundo.core.PropertyExpectation;
import org.exparity.expectamundo.core.Prototype;
import org.exparity.expectamundo.core.PrototypeProperty;
import org.exparity.expectamundo.core.PrototypePropertyMatcher;
import org.exparity.expectamundo.core.expectations.IsEqualTo;
import org.exparity.expectamundo.core.expectations.IsInstanceOf;
import org.exparity.expectamundo.core.expectations.IsNotEqualTo;
import org.exparity.expectamundo.core.expectations.IsNotNull;
import org.exparity.expectamundo.core.expectations.IsNull;
import org.exparity.expectamundo.core.expectations.IsOneOf;
import org.exparity.expectamundo.core.expectations.Matches;
import org.hamcrest.Matcher;

public class PrototypeObjectExpectation<T> {
    private final Prototype<?> prototype;
    private final PrototypeProperty property;

    public PrototypeObjectExpectation(Prototype<?> prototype, PrototypeProperty property) {
        this.prototype = prototype;
        this.property = property;
    }

    public void matches(Matcher<T> expected) {
        this.hasExpectation(new Matches<T>(expected));
    }

    public void isEqualTo(T expectedValue) {
        this.hasExpectation(new IsEqualTo<T>(expectedValue));
    }

    public void isNotEqualTo(T expectedValue) {
        this.hasExpectation(new IsNotEqualTo<T>(expectedValue));
    }

    public void isOneOf(T ... possibleValues) {
        this.isOneOf((Collection<T>)Arrays.asList(possibleValues));
    }

    public void isOneOf(Collection<T> possibleValues) {
        this.hasExpectation(new IsOneOf<T>(possibleValues));
    }

    public void isInstanceOf(Class<? extends T> expectedValue) {
        this.hasExpectation(new IsInstanceOf<T>(expectedValue));
    }

    public void isNull() {
        this.hasExpectation(new IsNull());
    }

    public void isNotNull() {
        this.hasExpectation(new IsNotNull());
    }

    public void hasExpectation(PropertyExpectation<T> expectation) {
        this.prototype.addExpectation(new PrototypePropertyMatcher(this.property, expectation));
        this.prototype.setActiveProperty(null);
    }
}

