/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo;

import java.util.Collection;
import java.util.Date;
import org.exparity.expectamundo.core.PrototypeChecker;
import org.exparity.expectamundo.core.PrototypeFactory;
import org.exparity.expectamundo.core.PrototypeListVerifier;
import org.exparity.expectamundo.core.PrototypeMatcherContext;
import org.exparity.expectamundo.core.PrototypeVerifier;
import org.exparity.expectamundo.core.Prototyped;
import org.exparity.expectamundo.core.TypeReference;
import org.exparity.expectamundo.core.array.PrototypeArrayExpectation;
import org.exparity.expectamundo.core.collection.PrototypeCollectionExpectation;
import org.exparity.expectamundo.core.comparable.PrototypeComparableExpectation;
import org.exparity.expectamundo.core.date.PrototypeDateExpectation;
import org.exparity.expectamundo.core.hamcrest.PrototypeMatcher;
import org.exparity.expectamundo.core.object.PrototypeObjectExpectation;
import org.exparity.expectamundo.core.string.PrototypeStringExpectation;
import org.hamcrest.Matcher;

public class Expectamundo {
    private static PrototypeFactory factory = new PrototypeFactory();

    public static <T> T prototype(Class<T> type) {
        return factory.createPrototype(type);
    }

    public static <T> T prototype(TypeReference<T> typeRef) {
        return (T)factory.createPrototype(typeRef.getType());
    }

    public static <E, T extends Collection<E>> PrototypeCollectionExpectation<E, T> expect(T property) {
        Expectamundo.checkActivePrototype();
        return new PrototypeCollectionExpectation(PrototypeMatcherContext.currentPrototype(), PrototypeMatcherContext.currentPrototype().getActiveProperty());
    }

    public static <T extends Comparable<T>> PrototypeComparableExpectation<T> expect(T property) {
        Expectamundo.checkActivePrototype();
        return new PrototypeComparableExpectation(PrototypeMatcherContext.currentPrototype(), PrototypeMatcherContext.currentPrototype().getActiveProperty());
    }

    public static <T> PrototypeArrayExpectation<T> expect(T[] property) {
        Expectamundo.checkActivePrototype();
        return new PrototypeArrayExpectation(PrototypeMatcherContext.currentPrototype(), PrototypeMatcherContext.currentPrototype().getActiveProperty());
    }

    public static PrototypeStringExpectation expect(String property) {
        Expectamundo.checkActivePrototype();
        return new PrototypeStringExpectation(PrototypeMatcherContext.currentPrototype(), PrototypeMatcherContext.currentPrototype().getActiveProperty());
    }

    public static PrototypeDateExpectation expect(Date property) {
        Expectamundo.checkActivePrototype();
        return new PrototypeDateExpectation(PrototypeMatcherContext.currentPrototype(), PrototypeMatcherContext.currentPrototype().getActiveProperty());
    }

    public static <T> PrototypeObjectExpectation<T> expect(T property) {
        Expectamundo.checkActivePrototype();
        return new PrototypeObjectExpectation(PrototypeMatcherContext.currentPrototype(), PrototypeMatcherContext.currentPrototype().getActiveProperty());
    }

    public static <T> PrototypeVerifier<T> expectThat(T actual) {
        return new PrototypeVerifier<T>(actual);
    }

    public static <E, T extends Collection<E>> PrototypeListVerifier<E, T> expectThat(T actual) {
        return new PrototypeListVerifier(actual);
    }

    public static <T> PrototypeChecker<T> checkThat(T actual) {
        return new PrototypeChecker<T>(actual);
    }

    public static <V, T extends V> T cast(V value, Class<T> type) {
        Expectamundo.checkActivePrototype();
        T prototype = factory.createPrototype(type, PrototypeMatcherContext.currentPrototype().getActiveProperty(), PrototypeMatcherContext.currentPrototype());
        PrototypeMatcherContext.currentPrototype().addChild((Prototyped)prototype);
        return prototype;
    }

    @Deprecated
    public static <T> Matcher<T> matcherFor(T prototype) {
        return Expectamundo.matchesPrototype(prototype);
    }

    public static <T> Matcher<T> matchesPrototype(T prototype) {
        return PrototypeMatcher.matchesPrototype(prototype);
    }

    public static boolean isPrototype(Object obj) {
        return obj instanceof Prototyped;
    }

    private static void checkActivePrototype() {
        if (PrototypeMatcherContext.currentPrototype() == null) {
            throw new IllegalArgumentException("You can only set an expectation on an instance created with Expectamundo.prototype()");
        }
        if (PrototypeMatcherContext.currentPrototype().getActiveProperty() == null) {
            throw new IllegalArgumentException("You can only set an expectation for a property");
        }
    }
}

