/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.exparity.expectamundo.core.PrototypeInterceptor;
import org.exparity.expectamundo.core.PrototypeProperty;
import org.exparity.expectamundo.core.PrototypePropertyMatcher;
import org.exparity.expectamundo.core.Prototyped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Prototype<T>
implements Prototyped<T>,
MethodInterceptor {
    private static Logger LOG = LoggerFactory.getLogger(Prototype.class);
    private final Class<T> rawType;
    private final PrototypeInterceptor interceptor;
    private final List<Prototyped<?>> children = new ArrayList();
    private final List<PrototypePropertyMatcher> expectations = new ArrayList<PrototypePropertyMatcher>();
    private final Map<String, Class<?>> typeParameters;
    private PrototypeProperty parentProperty = null;
    private PrototypeProperty activeProperty = null;

    public Prototype(PrototypeProperty parentProperty, Class<T> rawType, Map<String, Class<?>> typeParameters, PrototypeInterceptor proxier) {
        this.parentProperty = parentProperty;
        this.rawType = rawType;
        this.interceptor = proxier;
        this.typeParameters = typeParameters;
    }

    public Prototype(Class<T> rawType, Map<String, Class<?>> typeParameters, PrototypeInterceptor proxier) {
        this.rawType = rawType;
        this.interceptor = proxier;
        this.typeParameters = typeParameters;
    }

    public void addChild(Prototyped<?> child) {
        this.children.add(child);
    }

    public PrototypeProperty getParentProperty() {
        return this.parentProperty;
    }

    public void setActiveProperty(PrototypeProperty activeProperty) {
        LOG.debug("Current Property {}", (Object)(activeProperty == null ? "NONE" : activeProperty.getPath()));
        this.activeProperty = activeProperty;
    }

    public PrototypeProperty getActiveProperty() {
        return this.activeProperty;
    }

    @Override
    public List<PrototypePropertyMatcher> getExpectations() {
        ArrayList<PrototypePropertyMatcher> expectations = new ArrayList<PrototypePropertyMatcher>();
        expectations.addAll(this.expectations);
        for (Prototyped<?> child : this.children) {
            expectations.addAll(child.getExpectations());
        }
        return expectations;
    }

    public void addExpectation(PrototypePropertyMatcher expecation) {
        LOG.info("Expects {} {}", (Object)expecation.getPropertyPath(), (Object)expecation.getExpectation());
        this.expectations.add(expecation);
    }

    @Override
    public Class<T> getRawType() {
        return this.rawType;
    }

    public Map<String, Class<?>> getTypeParameters() {
        return this.typeParameters;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if (method.getDeclaringClass().equals(Prototyped.class)) {
            return this.getClass().getMethod(method.getName(), this.parameterTypes(args)).invoke((Object)this, new Object[0]);
        }
        return this.interceptor.intercept(obj, method, args, proxy, this);
    }

    private Class<?>[] parameterTypes(Object[] args) {
        if (args == null || args.length == 0) {
            return new Class[0];
        }
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            types[i] = args[i].getClass();
        }
        return types;
    }

    public String toString() {
        return "Prototype [" + this.rawType.getSimpleName() + "]";
    }
}

