/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Date;
import net.sf.cglib.proxy.MethodProxy;
import org.exparity.expectamundo.core.Prototype;
import org.exparity.expectamundo.core.PrototypeFactory;
import org.exparity.expectamundo.core.PrototypeInterceptor;
import org.exparity.expectamundo.core.PrototypeMatcherContext;
import org.exparity.expectamundo.core.PrototypeProperty;
import org.exparity.expectamundo.core.Prototyped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrototypeInterceptorImpl
implements PrototypeInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(PrototypeInterceptorImpl.class);
    private final PrototypeFactory factory;

    public PrototypeInterceptorImpl(PrototypeFactory factory) {
        this.factory = factory;
    }

    @Override
    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy, Prototype<?> currentPrototype) throws Throwable {
        PrototypeProperty activeProperty = new PrototypeProperty(currentPrototype.getParentProperty(), method, proxy, args, currentPrototype.getTypeParameters());
        if (this.isInvokedByLogger(activeProperty)) {
            LOG.debug("Discard Method [{}] invoke via logger", (Object)method);
            return proxy.invokeSuper(obj, args);
        }
        PrototypeMatcherContext.setCurrentPrototype(currentPrototype);
        currentPrototype.setActiveProperty(activeProperty);
        if (this.isProxiableMethod(method)) {
            Class<?> returnType = this.getClassForPrototype(activeProperty, currentPrototype);
            if (returnType.isPrimitive() || Modifier.isFinal(returnType.getModifiers()) || this.isJava8AndTypeNotProxiable(returnType)) {
                return null;
            }
            Object child = this.factory.createPrototype(activeProperty, currentPrototype);
            currentPrototype.addChild((Prototyped)child);
            return child;
        }
        LOG.debug("Discard Method [{}]", (Object)method);
        return proxy.invokeSuper(obj, args);
    }

    private boolean isJava8AndTypeNotProxiable(Class<?> returnType) {
        return System.getProperty("java.version").startsWith("1.8") && Date.class.isAssignableFrom(returnType);
    }

    private boolean isInvokedByLogger(PrototypeProperty activeProperty) {
        boolean logging = false;
        for (StackTraceElement x : Thread.currentThread().getStackTrace()) {
            if (!x.getClassName().startsWith("org.slf4j")) continue;
            LOG.debug("Discard {} during Logging", (Object)activeProperty);
            logging = true;
        }
        return logging;
    }

    private boolean isProxiableMethod(Method method) {
        switch (method.getName()) {
            case "iterator": 
            case "finalize": 
            case "hashCode": 
            case "toString": {
                return false;
            }
        }
        return method.getReturnType() != null;
    }

    private Class<?> getClassForPrototype(PrototypeProperty activeProperty, Prototype<?> currentPrototype) {
        Type genericType = activeProperty.getGenericReturnType();
        if (genericType instanceof Class) {
            return (Class)genericType;
        }
        if (genericType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)genericType).getRawType();
        }
        if (genericType instanceof TypeVariable) {
            return currentPrototype.getTypeParameters().get(((TypeVariable)genericType).getName());
        }
        throw new RuntimeException("Failed to get prototype class for '" + genericType + "'");
    }
}

