/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core;

import java.util.ArrayList;
import java.util.Collection;
import org.exparity.expectamundo.core.PrototypeListMatchResult;
import org.exparity.expectamundo.core.PrototypeMatchResult;
import org.exparity.expectamundo.core.PrototypeMatcher;
import org.exparity.expectamundo.core.PrototypeMismatchReporter;
import org.exparity.expectamundo.core.PrototypeVerifier;
import org.exparity.expectamundo.core.Prototyped;

public class PrototypeListVerifier<E, T extends Collection<E>>
extends PrototypeVerifier<T> {
    private final PrototypeMatcher<E> matcher = new PrototypeMatcher();
    private final PrototypeMismatchReporter descriptor = new PrototypeMismatchReporter();
    private final Collection<E> actual;

    public PrototypeListVerifier(T actual) {
        super(actual);
        this.actual = actual;
    }

    public void contains(E prototype) {
        if (!Prototyped.class.isInstance(prototype)) {
            throw new IllegalArgumentException("Object does not implement Prototyped. Please construct using Expectamundo.prototype");
        }
        ArrayList mismatches = new ArrayList();
        for (E entry : this.actual) {
            PrototypeMatchResult<E> result = this.matcher.compare(entry, prototype);
            if (result.isMismatch()) {
                mismatches.add(result);
                continue;
            }
            return;
        }
        throw new AssertionError((Object)this.descriptor.describeListMismatch(new PrototypeListMatchResult<E>(prototype, mismatches)));
    }
}

