/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core.collection;

import java.util.Collection;
import org.exparity.expectamundo.core.PropertyExpectation;
import org.exparity.expectamundo.core.PrototypeListMatchResult;
import org.exparity.expectamundo.core.PrototypeMatcher;
import org.exparity.expectamundo.core.PrototypeMismatchReporter;
import org.exparity.expectamundo.core.Prototyped;

public class ContainsExpected<E, T extends Collection<E>>
implements PropertyExpectation<T> {
    private final PrototypeMatcher<E> matcher = new PrototypeMatcher();
    private final PrototypeMismatchReporter reporter = new PrototypeMismatchReporter();
    private E prototype;

    public ContainsExpected(E prototype) {
        if (prototype != null && !Prototyped.class.isInstance(prototype)) {
            throw new IllegalArgumentException("Object does not implement Prototyped. Please construct using Expectamundo.prototype");
        }
        this.prototype = prototype;
    }

    @Override
    public boolean matches(T actual) {
        if (actual == null) {
            return false;
        }
        PrototypeListMatchResult<E> result = this.matcher.contains((Collection<E>)actual, this.prototype);
        if (result.isMismatch()) {
            throw new AssertionError((Object)this.reporter.describeListMismatch(result));
        }
        return true;
    }

    @Override
    public String describe() {
        return "contains " + this.prototype;
    }
}

