/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core.date;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.exparity.expectamundo.core.PropertyExpectation;

public class IsWithin
implements PropertyExpectation<Date> {
    private int interval;
    private TimeUnit unit;
    private Date expected;

    public IsWithin(int interval, TimeUnit unit, Date expected) {
        this.interval = interval;
        this.unit = unit;
        this.expected = expected;
    }

    @Override
    public boolean matches(Date actual) {
        long differenceInMillis = Math.abs(this.expected.getTime() - actual.getTime());
        return differenceInMillis <= TimeUnit.MILLISECONDS.convert(this.interval, this.unit);
    }

    @Override
    public String describe() {
        return "a expected within " + this.interval + " " + this.unit.name().toLowerCase() + " of " + this.expected;
    }
}

