/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core;

import org.exparity.expectamundo.core.PrototypeValueMatcher;
import org.exparity.expectamundo.core.Prototyped;

public class PrototypeChecker<T> {
    private final T actual;

    public PrototypeChecker(T actual) {
        this.actual = actual;
    }

    public boolean matches(T prototype) {
        if (!Prototyped.class.isInstance(prototype)) {
            throw new IllegalArgumentException("Object does not implement Prototyped. Please construct using PrototypeMatcher.expected");
        }
        StringBuffer mismatchDescription = new StringBuffer();
        Prototyped prototyped = (Prototyped)prototype;
        return this.matchesPrototype(prototyped, mismatchDescription);
    }

    protected boolean matchesPrototype(Prototyped<?> prototyped, StringBuffer mismatchDescription) {
        mismatchDescription.append("a ").append(this.actual.getClass().getSimpleName()).append(" containing properties :\n");
        boolean matches = true;
        for (PrototypeValueMatcher expectation : prototyped.getExpectations()) {
            Object actualValue;
            if (expectation.matches(actualValue = expectation.getPropertyValue(this.actual))) continue;
            mismatchDescription.append("\t").append(expectation.getPropertyPath()).append(" is ").append(actualValue);
            matches = false;
        }
        return matches;
    }
}

