/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core;

import java.util.List;
import org.exparity.expectamundo.core.PrototypeValueDifference;
import org.exparity.expectamundo.core.PrototypeValueMatcher;
import org.exparity.expectamundo.core.Prototyped;

public class PrototypeMatchResult<T> {
    private final List<PrototypeValueDifference> differences;
    private final T actual;
    private final T expected;

    public PrototypeMatchResult(T actual, T expected, List<PrototypeValueDifference> differences) {
        this.actual = actual;
        this.expected = expected;
        this.differences = differences;
    }

    public boolean isMismatch() {
        return !this.differences.isEmpty();
    }

    public Class<?> getExpectedType() {
        return ((Prototyped)this.expected).getRawType();
    }

    public Class<?> getActualType() {
        return this.actual.getClass();
    }

    public List<PrototypeValueDifference> getDifferences() {
        return this.differences;
    }

    public List<PrototypeValueMatcher> getExpectations() {
        return ((Prototyped)this.expected).getExpectations();
    }
}

