/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core;

import java.util.ArrayList;
import java.util.Collection;
import org.exparity.expectamundo.core.PrototypeListMatchResult;
import org.exparity.expectamundo.core.PrototypeMatchResult;
import org.exparity.expectamundo.core.PrototypeValueDifference;
import org.exparity.expectamundo.core.PrototypeValueMatcher;
import org.exparity.expectamundo.core.Prototyped;

public class PrototypeMatcher<T> {
    public PrototypeMatchResult<T> compare(T actual, T expectation) {
        if (!Prototyped.class.isInstance(expectation)) {
            throw new IllegalArgumentException("Object does not implement Prototyped. Please construct using Expectamundo.prototype");
        }
        ArrayList<PrototypeValueDifference> differences = new ArrayList<PrototypeValueDifference>();
        for (PrototypeValueMatcher expectedProperty : ((Prototyped)expectation).getExpectations()) {
            Object actualValue;
            if (expectedProperty.matches(actualValue = expectedProperty.getPropertyValue(actual))) continue;
            differences.add(new PrototypeValueDifference(expectedProperty.getPropertyPath(), actualValue));
        }
        return new PrototypeMatchResult<T>(actual, expectation, differences);
    }

    public PrototypeListMatchResult<T> contains(Collection<T> collection, T expectation) {
        ArrayList mismatches = new ArrayList();
        for (T entry : collection) {
            PrototypeMatchResult<T> result = this.compare(entry, expectation);
            if (result.isMismatch()) {
                mismatches.add(result);
                continue;
            }
            return new PrototypeListMatchResult<T>(expectation, mismatches);
        }
        return new PrototypeListMatchResult<T>(expectation, mismatches);
    }
}

