/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core;

import java.util.List;
import org.exparity.expectamundo.core.PrototypeListMatchResult;
import org.exparity.expectamundo.core.PrototypeMatchResult;
import org.exparity.expectamundo.core.PrototypeValueDifference;
import org.exparity.expectamundo.core.PrototypeValueMatcher;
import org.exparity.expectamundo.core.Prototyped;

public class PrototypeMismatchReporter {
    private static final String TEMPLATE = "\nExpected a %s containing properties:%s\nbut actual is a %s containing properties:%s";
    private static final String LISTTEMPLATE = "\nExpected a list containing a %s with properties:%s\nbut actual list contains:%s";

    public <T> String describeListMismatch(PrototypeListMatchResult<T> result) {
        return String.format(LISTTEMPLATE, this.describeExpectedType(result.getExpectationAsPrototype()), this.describeExpectations(result.getExpectations()), this.describeMismatches(result.getMismatches()));
    }

    public <T> String describeInstanceMismatch(PrototypeMatchResult<T> result) {
        return String.format(TEMPLATE, this.describeExpectedType(result), this.describeExpectations(result.getExpectations()), this.describeActualType(result), this.describeDifferences(result.getDifferences()));
    }

    private <T> String describeActualType(PrototypeMatchResult<T> result) {
        return result.getActualType().getSimpleName();
    }

    private <T> String describeExpectedType(PrototypeMatchResult<T> result) {
        return result.getExpectedType().getSimpleName();
    }

    private <T> String describeExpectedType(Prototyped<T> result) {
        return result.getRawType().getSimpleName();
    }

    private String describeExpectations(List<PrototypeValueMatcher> expectations) {
        StringBuffer buffer = new StringBuffer();
        for (PrototypeValueMatcher expecation : expectations) {
            buffer.append("\n\t").append(expecation.getPropertyPath()).append(" is ").append(expecation.getExpectation());
        }
        return buffer.toString();
    }

    private String describeDifferences(List<PrototypeValueDifference> mismatches) {
        StringBuffer buffer = new StringBuffer();
        for (PrototypeValueDifference mismatch : mismatches) {
            buffer.append("\n\t").append(mismatch.getPath()).append(" is ").append(mismatch.getValue());
        }
        return buffer.toString();
    }

    private <T> String describeMismatches(List<PrototypeMatchResult<T>> mismatches) {
        if (mismatches.isEmpty()) {
            return "No entries";
        }
        StringBuffer buffer = new StringBuffer();
        for (PrototypeMatchResult<T> mismatch : mismatches) {
            buffer.append("\n\t").append(this.describeActualType(mismatch)).append(" containing properties");
            for (PrototypeValueDifference difference : mismatch.getDifferences()) {
                buffer.append("\n\t\t").append(difference.getPath()).append(" is ").append(difference.getValue());
            }
        }
        return buffer.toString();
    }
}

